/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionListObserver;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.ByteSequence;

public class InstructionList
implements Serializable {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;
    private List observers;

    public InstructionList() {
    }

    public InstructionList(Instruction i2) {
        this.append(i2);
    }

    public InstructionList(BranchInstruction i2) {
        this.append(i2);
    }

    public InstructionList(CompoundInstruction c2) {
        this.append(c2.getInstructionList());
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] ihs, int[] pos, int count, int target) {
        int l2 = 0;
        int r2 = count - 1;
        do {
            int i2;
            int j2;
            if ((j2 = pos[i2 = (l2 + r2) / 2]) == target) {
                return ihs[i2];
            }
            if (target < j2) {
                r2 = i2 - 1;
                continue;
            }
            l2 = i2 + 1;
        } while (l2 <= r2);
        return null;
    }

    public InstructionHandle findHandle(int pos) {
        InstructionHandle[] ihs = this.getInstructionHandles();
        return InstructionList.findHandle(ihs, this.byte_positions, this.length, pos);
    }

    public InstructionList(byte[] code) {
        ByteSequence bytes = new ByteSequence(code);
        InstructionHandle[] ihs = new InstructionHandle[code.length];
        int[] pos = new int[code.length];
        int count = 0;
        try {
            while (bytes.available() > 0) {
                int off;
                pos[count] = off = bytes.getIndex();
                Instruction i2 = Instruction.readInstruction(bytes);
                InstructionHandle ih = i2 instanceof BranchInstruction ? this.append((BranchInstruction)i2) : this.append(i2);
                ih.setPosition(off);
                ihs[count] = ih;
                ++count;
            }
        }
        catch (IOException e2) {
            throw new ClassGenException(e2.toString());
        }
        this.byte_positions = new int[count];
        System.arraycopy(pos, 0, this.byte_positions, 0, count);
        for (int i3 = 0; i3 < count; ++i3) {
            if (!(ihs[i3] instanceof BranchHandle)) continue;
            BranchInstruction bi2 = (BranchInstruction)ihs[i3].instruction;
            int target = bi2.position + bi2.getIndex();
            InstructionHandle ih = InstructionList.findHandle(ihs, pos, count, target);
            if (ih == null) {
                throw new ClassGenException("Couldn't find target for branch: " + bi2);
            }
            bi2.setTarget(ih);
            if (!(bi2 instanceof Select)) continue;
            Select s2 = (Select)bi2;
            int[] indices = s2.getIndices();
            for (int j2 = 0; j2 < indices.length; ++j2) {
                target = bi2.position + indices[j2];
                ih = InstructionList.findHandle(ihs, pos, count, target);
                if (ih == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + bi2);
                }
                s2.setTarget(j2, ih);
            }
        }
    }

    public InstructionHandle append(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle next = ih.next;
        InstructionHandle ret = il.start;
        ih.next = il.start;
        il.start.prev = ih;
        il.end.next = next;
        if (next != null) {
            next.prev = il.end;
        } else {
            this.end = il.end;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle append(Instruction i2, InstructionList il) {
        InstructionHandle ih = this.findInstruction2(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        return this.append(ih, il);
    }

    public InstructionHandle append(InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = il.start;
            this.end = il.end;
            this.length = il.length;
            il.clear();
            return this.start;
        }
        return this.append(this.end, il);
    }

    private void append(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.end.next = ih;
            ih.prev = this.end;
            ih.next = null;
            this.end = ih;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction i2) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i2);
        this.append(ih);
        return ih;
    }

    public BranchHandle append(BranchInstruction i2) {
        BranchHandle ih = BranchHandle.getBranchHandle(i2);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(Instruction i2, Instruction j2) {
        return this.append(i2, new InstructionList(j2));
    }

    public InstructionHandle append(Instruction i2, CompoundInstruction c2) {
        return this.append(i2, c2.getInstructionList());
    }

    public InstructionHandle append(CompoundInstruction c2) {
        return this.append(c2.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, CompoundInstruction c2) {
        return this.append(ih, c2.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, Instruction i2) {
        return this.append(ih, new InstructionList(i2));
    }

    public BranchHandle append(InstructionHandle ih, BranchInstruction i2) {
        BranchHandle bh2 = BranchHandle.getBranchHandle(i2);
        InstructionList il = new InstructionList();
        il.append(bh2);
        this.append(ih, il);
        return bh2;
    }

    public InstructionHandle insert(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle prev = ih.prev;
        InstructionHandle ret = il.start;
        ih.prev = il.end;
        il.end.next = ih;
        il.start.prev = prev;
        if (prev != null) {
            prev.next = il.start;
        } else {
            this.start = il.start;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle insert(InstructionList il) {
        if (this.isEmpty()) {
            this.append(il);
            return this.start;
        }
        return this.insert(this.start, il);
    }

    private void insert(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.start.prev = ih;
            ih.next = this.start;
            ih.prev = null;
            this.start = ih;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction i2, InstructionList il) {
        InstructionHandle ih = this.findInstruction1(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        return this.insert(ih, il);
    }

    public InstructionHandle insert(Instruction i2) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i2);
        this.insert(ih);
        return ih;
    }

    public BranchHandle insert(BranchInstruction i2) {
        BranchHandle ih = BranchHandle.getBranchHandle(i2);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(Instruction i2, Instruction j2) {
        return this.insert(i2, new InstructionList(j2));
    }

    public InstructionHandle insert(Instruction i2, CompoundInstruction c2) {
        return this.insert(i2, c2.getInstructionList());
    }

    public InstructionHandle insert(CompoundInstruction c2) {
        return this.insert(c2.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle ih, Instruction i2) {
        return this.insert(ih, new InstructionList(i2));
    }

    public InstructionHandle insert(InstructionHandle ih, CompoundInstruction c2) {
        return this.insert(ih, c2.getInstructionList());
    }

    public BranchHandle insert(InstructionHandle ih, BranchInstruction i2) {
        BranchHandle bh2 = BranchHandle.getBranchHandle(i2);
        InstructionList il = new InstructionList();
        il.append(bh2);
        this.insert(ih, il);
        return bh2;
    }

    public void move(InstructionHandle start, InstructionHandle end, InstructionHandle target) {
        if (start == null || end == null) {
            throw new ClassGenException("Invalid null handle: From " + start + " to " + end);
        }
        if (target == start || target == end) {
            throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
        }
        InstructionHandle ih = start;
        while (ih != end.next) {
            if (ih == null) {
                throw new ClassGenException("Invalid range: From " + start + " to " + end);
            }
            if (ih == target) {
                throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
            }
            ih = ih.next;
        }
        InstructionHandle prev = start.prev;
        InstructionHandle next = end.next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.start = next;
        }
        if (next != null) {
            next.prev = prev;
        } else {
            this.end = prev;
        }
        end.next = null;
        start.prev = null;
        if (target == null) {
            if (this.start != null) {
                this.start.prev = end;
            }
            end.next = this.start;
            this.start = start;
        } else {
            next = target.next;
            target.next = start;
            start.prev = target;
            end.next = next;
            if (next != null) {
                next.prev = end;
            } else {
                this.end = end;
            }
        }
    }

    public void move(InstructionHandle ih, InstructionHandle target) {
        this.move(ih, ih, target);
    }

    private void remove(InstructionHandle prev, InstructionHandle next) throws TargetLostException {
        InstructionHandle first;
        InstructionHandle last;
        if (prev == null && next == null) {
            first = last = this.start;
            this.end = null;
            this.start = null;
        } else {
            if (prev == null) {
                first = this.start;
                this.start = next;
            } else {
                first = prev.next;
                prev.next = next;
            }
            if (next == null) {
                last = this.end;
                this.end = prev;
            } else {
                last = next.prev;
                next.prev = prev;
            }
        }
        first.prev = null;
        last.next = null;
        ArrayList<InstructionHandle> target_vec = new ArrayList<InstructionHandle>();
        InstructionHandle ih = first;
        while (ih != null) {
            ih.getInstruction().dispose();
            ih = ih.next;
        }
        StringBuffer buf = new StringBuffer("{ ");
        InstructionHandle ih2 = first;
        while (ih2 != null) {
            next = ih2.next;
            --this.length;
            if (ih2.hasTargeters()) {
                target_vec.add(ih2);
                buf.append(ih2.toString(true) + " ");
                ih2.prev = null;
                ih2.next = null;
            } else {
                ih2.dispose();
            }
            ih2 = next;
        }
        buf.append("}");
        if (!target_vec.isEmpty()) {
            InstructionHandle[] targeted = new InstructionHandle[target_vec.size()];
            target_vec.toArray(targeted);
            throw new TargetLostException(targeted, buf.toString());
        }
    }

    public void delete(InstructionHandle ih) throws TargetLostException {
        this.remove(ih.prev, ih.next);
    }

    public void delete(Instruction i2) throws TargetLostException {
        InstructionHandle ih = this.findInstruction1(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        this.delete(ih);
    }

    public void delete(InstructionHandle from, InstructionHandle to) throws TargetLostException {
        this.remove(from.prev, to.next);
    }

    public void delete(Instruction from, Instruction to) throws TargetLostException {
        InstructionHandle from_ih = this.findInstruction1(from);
        if (from_ih == null) {
            throw new ClassGenException("Instruction " + from + " is not contained in this list.");
        }
        InstructionHandle to_ih = this.findInstruction2(to);
        if (to_ih == null) {
            throw new ClassGenException("Instruction " + to + " is not contained in this list.");
        }
        this.delete(from_ih, to_ih);
    }

    private InstructionHandle findInstruction1(Instruction i2) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih.instruction == i2) {
                return ih;
            }
            ih = ih.next;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction i2) {
        InstructionHandle ih = this.end;
        while (ih != null) {
            if (ih.instruction == i2) {
                return ih;
            }
            ih = ih.prev;
        }
        return null;
    }

    public boolean contains(InstructionHandle i2) {
        if (i2 == null) {
            return false;
        }
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih == i2) {
                return true;
            }
            ih = ih.next;
        }
        return false;
    }

    public boolean contains(Instruction i2) {
        return this.findInstruction1(i2) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean check) {
        Instruction i2;
        InstructionHandle ih;
        int max_additional_bytes = 0;
        int additional_bytes = 0;
        int index = 0;
        int count = 0;
        int[] pos = new int[this.length];
        if (check) {
            ih = this.start;
            while (ih != null) {
                i2 = ih.instruction;
                if (i2 instanceof BranchInstruction) {
                    Instruction inst = ((BranchInstruction)i2).getTarget().instruction;
                    if (!this.contains(inst)) {
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i2.opcode] + ":" + inst + " not in instruction list");
                    }
                    if (i2 instanceof Select) {
                        InstructionHandle[] targets = ((Select)i2).getTargets();
                        for (int j2 = 0; j2 < targets.length; ++j2) {
                            inst = targets[j2].instruction;
                            if (this.contains(inst)) continue;
                            throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i2.opcode] + ":" + inst + " not in instruction list");
                        }
                    }
                    if (!(ih instanceof BranchHandle)) {
                        throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[i2.opcode] + ":" + inst + " not contained in BranchHandle.");
                    }
                }
                ih = ih.next;
            }
        }
        ih = this.start;
        while (ih != null) {
            i2 = ih.instruction;
            ih.setPosition(index);
            pos[count++] = index;
            switch (i2.getOpcode()) {
                case 167: 
                case 168: {
                    max_additional_bytes += 2;
                    break;
                }
                case 170: 
                case 171: {
                    max_additional_bytes += 3;
                }
            }
            index += i2.getLength();
            ih = ih.next;
        }
        ih = this.start;
        while (ih != null) {
            additional_bytes += ih.updatePosition(additional_bytes, max_additional_bytes);
            ih = ih.next;
        }
        count = 0;
        index = 0;
        ih = this.start;
        while (ih != null) {
            i2 = ih.instruction;
            ih.setPosition(index);
            pos[count++] = index;
            index += i2.getLength();
            ih = ih.next;
        }
        this.byte_positions = new int[count];
        System.arraycopy(pos, 0, this.byte_positions, 0, count);
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream b3 = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b3);
        try {
            InstructionHandle ih = this.start;
            while (ih != null) {
                Instruction i2 = ih.instruction;
                i2.dump(out);
                ih = ih.next;
            }
        }
        catch (IOException e2) {
            System.err.println(e2);
            return null;
        }
        return b3.toByteArray();
    }

    public Instruction[] getInstructions() {
        ByteSequence bytes = new ByteSequence(this.getByteCode());
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        try {
            while (bytes.available() > 0) {
                instructions.add(Instruction.readInstruction(bytes));
            }
        }
        catch (IOException e2) {
            throw new ClassGenException(e2.toString());
        }
        return instructions.toArray(new Instruction[instructions.size()]);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer();
        InstructionHandle ih = this.start;
        while (ih != null) {
            buf.append(ih.toString(verbose)).append("\n");
            ih = ih.next;
        }
        return buf.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            public Object next() {
                InstructionHandle i2 = this.ih;
                this.ih = this.ih.next;
                return i2;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.ih != null;
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] ihs = new InstructionHandle[this.length];
        InstructionHandle ih = this.start;
        for (int i2 = 0; i2 < this.length; ++i2) {
            ihs[i2] = ih;
            ih = ih.next;
        }
        return ihs;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public InstructionList copy() {
        HashMap<InstructionHandle, InstructionHandle> map = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList il = new InstructionList();
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i2 = ih.instruction;
            Instruction c2 = i2.copy();
            if (c2 instanceof BranchInstruction) {
                map.put(ih, il.append((BranchInstruction)c2));
            } else {
                map.put(ih, il.append(c2));
            }
            ih = ih.next;
        }
        ih = this.start;
        InstructionHandle ch = il.start;
        while (ih != null) {
            Instruction i3 = ih.instruction;
            Instruction c3 = ch.instruction;
            if (i3 instanceof BranchInstruction) {
                BranchInstruction bi2 = (BranchInstruction)i3;
                BranchInstruction bc2 = (BranchInstruction)c3;
                InstructionHandle itarget = bi2.getTarget();
                bc2.setTarget((InstructionHandle)map.get(itarget));
                if (bi2 instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi2).getTargets();
                    InstructionHandle[] ctargets = ((Select)bc2).getTargets();
                    for (int j2 = 0; j2 < itargets.length; ++j2) {
                        ctargets[j2] = (InstructionHandle)map.get(itargets[j2]);
                    }
                }
            }
            ih = ih.next;
            ch = ch.next;
        }
        return il;
    }

    public void replaceConstantPool(ConstantPoolGen old_cp, ConstantPoolGen new_cp) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i2 = ih.instruction;
            if (i2 instanceof CPInstruction) {
                CPInstruction ci = (CPInstruction)i2;
                Constant c2 = old_cp.getConstant(ci.getIndex());
                ci.setIndex(new_cp.addConstant(c2, old_cp));
            }
            ih = ih.next;
        }
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        InstructionHandle ih = this.end;
        while (ih != null) {
            ih.dispose();
            ih = ih.prev;
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle old_target, InstructionHandle new_target) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i2 = ih.getInstruction();
            if (i2 instanceof BranchInstruction) {
                BranchInstruction b3 = (BranchInstruction)i2;
                InstructionHandle target = b3.getTarget();
                if (target == old_target) {
                    b3.setTarget(new_target);
                }
                if (b3 instanceof Select) {
                    InstructionHandle[] targets = ((Select)b3).getTargets();
                    for (int j2 = 0; j2 < targets.length; ++j2) {
                        if (targets[j2] != old_target) continue;
                        ((Select)b3).setTarget(j2, new_target);
                    }
                }
            }
            ih = ih.next;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] lg, InstructionHandle old_target, InstructionHandle new_target) {
        for (int i2 = 0; i2 < lg.length; ++i2) {
            InstructionHandle start = lg[i2].getStart();
            InstructionHandle end = lg[i2].getEnd();
            if (start == old_target) {
                lg[i2].setStart(new_target);
            }
            if (end != old_target) continue;
            lg[i2].setEnd(new_target);
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] exceptions, InstructionHandle old_target, InstructionHandle new_target) {
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            if (exceptions[i2].getStartPC() == old_target) {
                exceptions[i2].setStartPC(new_target);
            }
            if (exceptions[i2].getEndPC() == old_target) {
                exceptions[i2].setEndPC(new_target);
            }
            if (exceptions[i2].getHandlerPC() != old_target) continue;
            exceptions[i2].setHandlerPC(new_target);
        }
    }

    public void addObserver(InstructionListObserver o2) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o2);
    }

    public void removeObserver(InstructionListObserver o2) {
        if (this.observers != null) {
            this.observers.remove(o2);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e2 = this.observers.iterator();
            while (e2.hasNext()) {
                ((InstructionListObserver)e2.next()).notify(this);
            }
        }
    }
}

