/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static ThreadLocal consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    static int[] CHAR_MAP;
    static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    private static int unwrap(ThreadLocal tl) {
        return (Integer)tl.get();
    }

    private static void wrap(ThreadLocal tl, int value) {
        tl.set(new Integer(value));
    }

    public static final String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static final String accessToString(int access_flags, boolean for_class) {
        StringBuffer buf = new StringBuffer();
        int p2 = 0;
        int i2 = 0;
        while (p2 < 16384) {
            p2 = Utility.pow2(i2);
            if ((access_flags & p2) != 0 && (!for_class || p2 != 32 && p2 != 512)) {
                buf.append(Constants.ACCESS_NAMES[i2]).append(" ");
            }
            ++i2;
        }
        return buf.toString().trim();
    }

    public static final String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length, boolean verbose) {
        StringBuffer buf = new StringBuffer(code.length * 20);
        ByteSequence stream = new ByteSequence(code);
        try {
            int i2;
            for (i2 = 0; i2 < index; ++i2) {
                Utility.codeToString(stream, constant_pool, verbose);
            }
            i2 = 0;
            while (stream.available() > 0) {
                if (length < 0 || i2 < length) {
                    String indices = Utility.fillup(stream.getIndex() + ":", 6, true, ' ');
                    buf.append(indices).append(Utility.codeToString(stream, constant_pool, verbose)).append('\n');
                }
                ++i2;
            }
        }
        catch (IOException e2) {
            System.out.println(buf.toString());
            e2.printStackTrace();
            throw new ClassFormatException("Byte code error: " + e2);
        }
        return buf.toString();
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool, boolean verbose) throws IOException {
        int i2;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(Constants.OPCODE_NAMES[opcode]);
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (i2 = 0; i2 < no_pad_bytes; ++i2) {
                byte b3 = bytes.readByte();
                if (b3 == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[opcode] + ":" + b3);
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int i3;
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = ").append(default_offset += offset).append(", low = ").append(low).append(", high = ").append(high).append("(");
                int[] jump_table = new int[high - low + 1];
                for (i3 = 0; i3 < jump_table.length; ++i3) {
                    jump_table[i3] = offset + bytes.readInt();
                    buf.append(jump_table[i3]);
                    if (i3 >= jump_table.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 171: {
                int i3;
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = ").append(default_offset += offset).append(", npairs = ").append(npairs).append(" (");
                for (i3 = 0; i3 < npairs; ++i3) {
                    match[i3] = bytes.readInt();
                    jump_table[i3] = offset + bytes.readInt();
                    buf.append("(").append(match[i3]).append(", ").append(jump_table[i3]).append(")");
                    if (i3 >= npairs - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readShort());
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<").append(Constants.TYPE_NAMES[bytes.readByte()]).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, (byte)9)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<").append(constant_pool.constantToString(index, (byte)7)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)10)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)11)).append(verbose ? " (" + index + ")\t" : "").append(nargs).append("\t").append(bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">\t").append(dimensions).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%").append(vindex).append("\t").append(constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                block27: for (i2 = 0; i2 < Constants.TYPE_OF_OPERANDS[opcode].length; ++i2) {
                    buf.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i2]) {
                        case 8: {
                            buf.append(bytes.readByte());
                            continue block27;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            continue block27;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            continue block27;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                }
            }
        }
        return buf.toString();
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static final String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static final int setBit(int flag, int i2) {
        return flag | Utility.pow2(i2);
    }

    public static final int clearBit(int flag, int i2) {
        int bit = Utility.pow2(i2);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static final boolean isSet(int flag, int i2) {
        return (flag & Utility.pow2(i2)) != 0;
    }

    public static final String methodTypeToSignature(String ret, String[] argv) throws ClassFormatException {
        String str;
        StringBuffer buf = new StringBuffer("(");
        if (argv != null) {
            for (int i2 = 0; i2 < argv.length; ++i2) {
                str = Utility.getSignature(argv[i2]);
                if (str.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + argv[i2]);
                }
                buf.append(str);
            }
        }
        str = Utility.getSignature(ret);
        buf.append(")").append(str);
        return buf.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(Utility.signatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static final String methodSignatureReturnType(String signature) throws ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static final String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatException {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            type = Utility.signatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return type;
    }

    public static final String methodSignatureToString(String signature, String name, String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit) {
        return Utility.methodSignatureToString(signature, name, access, chopit, null);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit, LocalVariableTable vars) throws ClassFormatException {
        String type;
        StringBuffer buf = new StringBuffer("(");
        int var_index = access.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                String param_type = Utility.signatureToString(signature.substring(index), chopit);
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l2 = vars.getLocalVariable(var_index);
                    if (l2 != null) {
                        buf.append(" ").append(l2.getName());
                    }
                } else {
                    buf.append(" arg").append(var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index += Utility.unwrap(consumed_chars);
            }
            type = Utility.signatureToString(signature.substring(++index), chopit);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return access + (access.length() > 0 ? " " : "") + type + " " + name + buf.toString();
    }

    private static final int pow2(int n2) {
        return 1 << n2;
    }

    public static final String replace(String str, String old, String new_) {
        StringBuffer buf = new StringBuffer();
        try {
            int index = str.indexOf(old);
            if (index != -1) {
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e2) {
            System.err.println(e2);
        }
        return str;
    }

    public static final String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static final String signatureToString(String signature, boolean chopit) {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    Utility.wrap(consumed_chars, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n2 = 0;
                    while (signature.charAt(n2) == '[') {
                        brackets.append("[]");
                        ++n2;
                    }
                    int consumed_chars = n2;
                    String type = Utility.signatureToString(signature.substring(n2), chopit);
                    int _temp = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                    Utility.wrap(Utility.consumed_chars, _temp);
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid signature: " + e2 + ":" + signature);
        }
    }

    public static String getSignature(String type) {
        StringBuffer buf = new StringBuffer();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        block4: for (int i2 = 0; i2 < chars.length; ++i2) {
            switch (chars[i2]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) continue block4;
                    delim = true;
                    continue block4;
                }
                case '[': {
                    if (!char_found) {
                        throw new RuntimeException("Illegal type: " + type);
                    }
                    index = i2;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) continue block4;
                    buf.append(chars[i2]);
                }
            }
        }
        int brackets = 0;
        if (index > 0) {
            brackets = Utility.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        for (int i3 = 0; i3 < brackets; ++i3) {
            buf.append('[');
        }
        boolean found = false;
        for (int i4 = 4; i4 <= 12 && !found; ++i4) {
            if (!Constants.TYPE_NAMES[i4].equals(type)) continue;
            found = true;
            buf.append(Constants.SHORT_TYPE_NAMES[i4]);
        }
        if (!found) {
            buf.append('L').append(type.replace('.', '/')).append(';');
        }
        return buf.toString();
    }

    private static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        block4: for (int i2 = 0; i2 < chars.length; ++i2) {
            switch (chars[i2]) {
                case '[': {
                    if (open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    continue block4;
                }
                case ']': {
                    if (!open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                    continue block4;
                }
            }
        }
        if (open) {
            throw new RuntimeException("Illegally nested brackets:" + brackets);
        }
        return count;
    }

    public static final byte typeOfMethodSignature(String signature) throws ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static final byte typeOfSignature(String signature) throws ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static short searchOpcode(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (short i2 = 0; i2 < Constants.OPCODE_NAMES.length; i2 = (short)(i2 + 1)) {
            if (!Constants.OPCODE_NAMES[i2].equals(name)) continue;
            return i2;
        }
        return -1;
    }

    private static final short byteToShort(byte b3) {
        return b3 < 0 ? (short)(256 + b3) : (short)b3;
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            short b3 = Utility.byteToShort(bytes[i2]);
            String hex = Integer.toString(b3, 16);
            if (b3 < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i2 >= bytes.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static final String format(int i2, int length, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i2), length, left_justify, fill);
    }

    public static final String fillup(String str, int length, boolean left_justify, char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        for (int j2 = 0; j2 < buf.length; ++j2) {
            buf[j2] = fill;
        }
        if (left_justify) {
            return str + new String(buf);
        }
        return new String(buf) + str;
    }

    static final boolean equals(byte[] a, byte[] b3) {
        int size = a.length;
        if (size != b3.length) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (a[i2] == b3[i2]) continue;
            return false;
        }
        return true;
    }

    public static final void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static final String printArray(Object[] obj, boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static final String printArray(Object[] obj, boolean braces, boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (braces) {
            buf.append('{');
        }
        for (int i2 = 0; i2 < obj.length; ++i2) {
            if (obj[i2] != null) {
                buf.append(quote ? "\"" : "").append(obj[i2].toString()).append(quote ? "\"" : "");
            } else {
                buf.append("null");
            }
            if (i2 >= obj.length - 1) continue;
            buf.append(", ");
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public static String encode(byte[] bytes, boolean compress) throws IOException {
        if (compress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(bytes, 0, bytes.length);
            gos.close();
            baos.close();
            bytes = baos.toByteArray();
        }
        CharArrayWriter caw = new CharArrayWriter();
        JavaWriter jw = new JavaWriter(caw);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int in = bytes[i2] & 0xFF;
            jw.write(in);
        }
        return caw.toString();
    }

    public static byte[] decode(String s2, boolean uncompress) throws IOException {
        int ch;
        char[] chars = s2.toCharArray();
        CharArrayReader car = new CharArrayReader(chars);
        JavaReader jr = new JavaReader(car);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((ch = jr.read()) >= 0) {
            bos.write(ch);
        }
        bos.close();
        car.close();
        jr.close();
        byte[] bytes = bos.toByteArray();
        if (uncompress) {
            int b3;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
            byte[] tmp = new byte[bytes.length * 3];
            int count = 0;
            while ((b3 = gis.read()) >= 0) {
                tmp[count++] = (byte)b3;
            }
            bytes = new byte[count];
            System.arraycopy(tmp, 0, bytes, 0, count);
        }
        return bytes;
    }

    public static final String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuffer buf = new StringBuffer();
        block7: for (int i2 = 0; i2 < ch.length; ++i2) {
            switch (ch[i2]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                default: {
                    buf.append(ch[i2]);
                }
            }
        }
        return buf.toString();
    }

    static {
        int i2;
        consumed_chars = new ThreadLocal(){

            protected Object initialValue() {
                return new Integer(0);
            }
        };
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int j2 = 0;
        for (i2 = 65; i2 <= 90; ++i2) {
            Utility.CHAR_MAP[j2] = i2;
            Utility.MAP_CHAR[i2] = j2++;
        }
        for (i2 = 103; i2 <= 122; ++i2) {
            Utility.CHAR_MAP[j2] = i2;
            Utility.MAP_CHAR[i2] = j2++;
        }
        Utility.CHAR_MAP[j2] = 36;
        Utility.MAP_CHAR[36] = j2++;
        Utility.CHAR_MAP[j2] = 95;
        Utility.MAP_CHAR[95] = j2;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer out) {
            super(out);
        }

        public void write(int b3) throws IOException {
            if (Utility.isJavaIdentifierPart((char)b3) && b3 != 36) {
                this.out.write(b3);
            } else {
                this.out.write(36);
                if (b3 >= 0 && b3 < 48) {
                    this.out.write(CHAR_MAP[b3]);
                } else {
                    char[] tmp = Integer.toHexString(b3).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i2 = 0; i2 < len; ++i2) {
                this.write(cbuf[off + i2]);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            int b3 = this.in.read();
            if (b3 != 36) {
                return b3;
            }
            int i2 = this.in.read();
            if (i2 < 0) {
                return -1;
            }
            if (i2 >= 48 && i2 <= 57 || i2 >= 97 && i2 <= 102) {
                int j2 = this.in.read();
                if (j2 < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i2, (char)j2};
                int s2 = Integer.parseInt(new String(tmp), 16);
                return s2;
            }
            return MAP_CHAR[i2];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            for (int i2 = 0; i2 < len; ++i2) {
                cbuf[off + i2] = (char)this.read();
            }
            return len;
        }
    }
}

