/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.ConstantInt;
import llvm.Instruction;
import llvm.TerminatorInst;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class SwitchInst
extends TerminatorInst {
    private long swigCPtr;

    protected SwitchInst(long l2, boolean bl2) {
        super(llvmJNI.SWIGSwitchInstUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(SwitchInst switchInst) {
        return switchInst == null ? 0L : switchInst.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_SwitchInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static SwitchInst Create(Value value, BasicBlock basicBlock, long l2, Instruction instruction) {
        long l3 = llvmJNI.SwitchInst_Create__SWIG_0(Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock, l2, Instruction.getCPtr(instruction), instruction);
        return l3 == 0L ? null : new SwitchInst(l3, false);
    }

    public static SwitchInst Create(Value value, BasicBlock basicBlock, long l2) {
        long l3 = llvmJNI.SwitchInst_Create__SWIG_1(Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock, l2);
        return l3 == 0L ? null : new SwitchInst(l3, false);
    }

    public static SwitchInst Create(Value value, BasicBlock basicBlock, long l2, BasicBlock basicBlock2) {
        long l3 = llvmJNI.SwitchInst_Create__SWIG_2(Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock, l2, BasicBlock.getCPtr(basicBlock2), basicBlock2);
        return l3 == 0L ? null : new SwitchInst(l3, false);
    }

    public Value getOperand(long l2) {
        long l3 = llvmJNI.SwitchInst_getOperand(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setOperand(long l2, Value value) {
        llvmJNI.SwitchInst_setOperand(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l2 = llvmJNI.SwitchInst_op_begin__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public Use op_end() {
        long l2 = llvmJNI.SwitchInst_op_end__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public long getNumOperands() {
        return llvmJNI.SwitchInst_getNumOperands(this.swigCPtr, this);
    }

    public Value getCondition() {
        long l2 = llvmJNI.SwitchInst_getCondition(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setCondition(Value value) {
        llvmJNI.SwitchInst_setCondition(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public BasicBlock getDefaultDest() {
        long l2 = llvmJNI.SwitchInst_getDefaultDest(this.swigCPtr, this);
        return l2 == 0L ? null : new BasicBlock(l2, false);
    }

    public long getNumCases() {
        return llvmJNI.SwitchInst_getNumCases(this.swigCPtr, this);
    }

    public ConstantInt getCaseValue(long l2) {
        long l3 = llvmJNI.SwitchInst_getCaseValue__SWIG_0(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new ConstantInt(l3, false);
    }

    public long findCaseValue(ConstantInt constantInt) {
        return llvmJNI.SwitchInst_findCaseValue(this.swigCPtr, this, ConstantInt.getCPtr(constantInt), constantInt);
    }

    public ConstantInt findCaseDest(BasicBlock basicBlock) {
        long l2 = llvmJNI.SwitchInst_findCaseDest(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public void addCase(ConstantInt constantInt, BasicBlock basicBlock) {
        llvmJNI.SwitchInst_addCase(this.swigCPtr, this, ConstantInt.getCPtr(constantInt), constantInt, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public void removeCase(long l2) {
        llvmJNI.SwitchInst_removeCase(this.swigCPtr, this, l2);
    }

    public long getNumSuccessors() {
        return llvmJNI.SwitchInst_getNumSuccessors(this.swigCPtr, this);
    }

    public BasicBlock getSuccessor(long l2) {
        long l3 = llvmJNI.SwitchInst_getSuccessor(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new BasicBlock(l3, false);
    }

    public void setSuccessor(long l2, BasicBlock basicBlock) {
        llvmJNI.SwitchInst_setSuccessor(this.swigCPtr, this, l2, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public ConstantInt getSuccessorValue(long l2) {
        long l3 = llvmJNI.SwitchInst_getSuccessorValue(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new ConstantInt(l3, false);
    }

    public static boolean classof(SwitchInst switchInst) {
        return llvmJNI.SwitchInst_classof__SWIG_0(SwitchInst.getCPtr(switchInst), switchInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.SwitchInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.SwitchInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static SwitchInst dyn_cast(TerminatorInst terminatorInst) {
        long l2 = llvmJNI.SwitchInst_dyn_cast(TerminatorInst.getCPtr(terminatorInst), terminatorInst);
        return l2 == 0L ? null : new SwitchInst(l2, false);
    }
}

