/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.Constant;
import llvm.ConstantInt;
import llvm.IntrinsicInst;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;

public class MemIntrinsic
extends IntrinsicInst {
    private long swigCPtr;

    protected MemIntrinsic(long l2, boolean bl2) {
        super(llvmJNI.SWIGMemIntrinsicUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(MemIntrinsic memIntrinsic) {
        return memIntrinsic == null ? 0L : memIntrinsic.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_MemIntrinsic(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Value getRawDest() {
        long l2 = llvmJNI.MemIntrinsic_getRawDest(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value getLength() {
        long l2 = llvmJNI.MemIntrinsic_getLength(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public ConstantInt getAlignmentCst() {
        long l2 = llvmJNI.MemIntrinsic_getAlignmentCst(this.swigCPtr, this);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public long getAlignment() {
        return llvmJNI.MemIntrinsic_getAlignment(this.swigCPtr, this);
    }

    public Value getDest() {
        long l2 = llvmJNI.MemIntrinsic_getDest(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setDest(Value value) {
        llvmJNI.MemIntrinsic_setDest(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void setLength(Value value) {
        llvmJNI.MemIntrinsic_setLength(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void setAlignment(Constant constant) {
        llvmJNI.MemIntrinsic_setAlignment(this.swigCPtr, this, Constant.getCPtr(constant), constant);
    }

    public Type getAlignmentType() {
        long l2 = llvmJNI.MemIntrinsic_getAlignmentType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public static boolean classof(MemIntrinsic memIntrinsic) {
        return llvmJNI.MemIntrinsic_classof__SWIG_0(MemIntrinsic.getCPtr(memIntrinsic), memIntrinsic);
    }

    public static boolean classof(IntrinsicInst intrinsicInst) {
        return llvmJNI.MemIntrinsic_classof__SWIG_1(IntrinsicInst.getCPtr(intrinsicInst), intrinsicInst);
    }

    public static boolean classof(Value value) {
        return llvmJNI.MemIntrinsic_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static MemIntrinsic dyn_cast(IntrinsicInst intrinsicInst) {
        long l2 = llvmJNI.MemIntrinsic_dyn_cast(IntrinsicInst.getCPtr(intrinsicInst), intrinsicInst);
        return l2 == 0L ? null : new MemIntrinsic(l2, false);
    }
}

