/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.Utils;
import java.io.UnsupportedEncodingException;

public class JA_SSLCKeyEncode {
    static final String a = System.getProperty("line.separator");
    static final byte[] b = JA_SSLCKeyEncode.getBytes(a, "8859_1");

    public static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static boolean isSpace(char c2) {
        switch (c2) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static byte[] pemEncode(byte[] byArray, String string, byte[] byArray2) {
        String string2 = null;
        try {
            string2 = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.equals("CLEAR")) {
            stringBuffer = stringBuffer.append("-----BEGIN RSA PRIVATE KEY-----").append(a);
            stringBuffer = stringBuffer.append(string2).append(a);
            stringBuffer = stringBuffer.append("-----END RSA PRIVATE KEY-----");
            String string3 = stringBuffer.toString();
            try {
                return string3.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string3.getBytes();
            }
        }
        String string4 = null;
        String string5 = null;
        if (string.equals("DES")) {
            string4 = "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-CBC,";
        } else if (string.equals("3DES_EDE")) {
            string4 = "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,";
        }
        string5 = JA_SSLCKeyEncode.byteArrayToHexString(byArray2, 0, byArray2.length);
        stringBuffer = stringBuffer.append("-----BEGIN RSA PRIVATE KEY-----").append(a);
        stringBuffer = stringBuffer.append(string4).append(string5).append("\n\n");
        stringBuffer = stringBuffer.append(string2).append(a).append("-----END RSA PRIVATE KEY-----");
        try {
            return stringBuffer.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return stringBuffer.toString().getBytes();
        }
    }

    public static byte[] pemDecodeNotEncrypted(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = null;
        String string = null;
        int n2 = -1;
        int n3 = -1;
        Object var5_5 = null;
        String string2 = "-----BEGIN RSA PRIVATE KEY-----";
        try {
            string = new String(byArray, 0, byArray.length, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, 0, byArray.length);
        }
        int n4 = string.indexOf(string2);
        if (n4 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing header");
        }
        n2 = n4 + string2.length();
        while (JA_SSLCKeyEncode.isSpace(string.charAt(n2))) {
            ++n2;
        }
        n3 = string.indexOf("-", n2);
        if (n3 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing footer");
        }
        int n5 = n3 - n2;
        int n6 = n3;
        while (Character.isWhitespace(string.charAt(n2 + n5 - 1))) {
            --n5;
            --n6;
        }
        String string3 = string.substring(n2, n6);
        try {
            byArray2 = string3.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string3.getBytes();
        }
        return byArray2;
    }

    public static byte[] base64Decode(byte[] byArray) throws JSAFE_InvalidKeyException {
        JSAFE_Recode jSAFE_Recode = null;
        try {
            byte[] byArray2;
            jSAFE_Recode = JSAFE_Recode.getInstance("Base64-64", "Java");
            jSAFE_Recode.decodeInit();
            int n2 = jSAFE_Recode.getOutputBufferSize(byArray.length);
            byte[] byArray3 = new byte[n2];
            int n3 = jSAFE_Recode.decodeUpdate(byArray, 0, byArray.length, byArray3, 0);
            int n4 = jSAFE_Recode.decodeFinal(byArray3, n3);
            int n5 = n3 + n4;
            if (n5 != n2) {
                byArray2 = new byte[n5];
                System.arraycopy(byArray3, 0, byArray2, 0, n5);
                byArray3 = byArray2;
            }
            byArray2 = byArray3;
            return byArray2;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidKeyException(jSAFE_UnimplementedException.getMessage());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new JSAFE_InvalidKeyException(jSAFE_InvalidUseException.getMessage());
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InvalidKeyException(jSAFE_InputException.getMessage());
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new JSAFE_InvalidKeyException(jSAFE_InvalidParameterException.getMessage());
        }
        finally {
            if (jSAFE_Recode != null) {
                jSAFE_Recode.clearSensitiveData();
            }
        }
    }

    static byte[] a(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 / n3;
        int n6 = n2 - n5 * n3;
        if (n6 > 0) {
            ++n5;
        }
        int n7 = n5 * b.length;
        int n8 = n2 + n7;
        byte[] byArray2 = new byte[n8];
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray2[n4] = 0;
        }
        int n9 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            byArray2[n9++] = byArray[n4];
            if (n4 % n3 != n3 - 1) continue;
            for (int i2 = 0; i2 < b.length; ++i2) {
                byArray2[n9++] = b[i2];
            }
        }
        return byArray2;
    }

    public static byte[] base64Encode(byte[] byArray) throws JSAFE_InvalidKeyException {
        JSAFE_Recode jSAFE_Recode = null;
        try {
            byte[] byArray2;
            jSAFE_Recode = JSAFE_Recode.getInstance("Base64-64", "Java");
            jSAFE_Recode.encodeInit();
            int n2 = jSAFE_Recode.getOutputBufferSize(byArray.length);
            byte[] byArray3 = new byte[n2];
            int n3 = jSAFE_Recode.encodeUpdate(byArray, 0, byArray.length, byArray3, 0);
            int n4 = jSAFE_Recode.encodeFinal(byArray3, n3);
            int n5 = n3 + n4;
            byte[] byArray4 = byArray3;
            if (n5 != n2) {
                byArray2 = new byte[n5];
                System.arraycopy(byArray4, 0, byArray2, 0, n5);
                byArray4 = byArray2;
            }
            byArray2 = byArray4;
            return byArray2;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidKeyException(jSAFE_UnimplementedException.getMessage());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new JSAFE_InvalidKeyException(jSAFE_InvalidUseException.getMessage());
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new JSAFE_InvalidKeyException(jSAFE_InvalidParameterException.getMessage());
        }
        finally {
            if (jSAFE_Recode != null) {
                jSAFE_Recode.clearSensitiveData();
            }
        }
    }

    public static byte[] pemDecodeEncrypted(byte[] byArray, String[] stringArray, byte[] byArray2) throws JSAFE_InvalidKeyException {
        byte[] byArray3;
        String string = "-----BEGIN RSA PRIVATE KEY-----";
        String string2 = "-----END RSA PRIVATE KEY-----";
        String string3 = "DEK-Info: DES-CBC,";
        String string4 = "DEK-Info: DES-EDE3-CBC,";
        String string5 = null;
        try {
            string5 = new String(byArray, 0, byArray.length, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string5 = new String(byArray, 0, byArray.length);
        }
        int n2 = string5.indexOf(string);
        if (n2 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing header");
        }
        int n3 = string5.indexOf(string3);
        int n4 = string5.indexOf(string4);
        int n5 = 8;
        int n6 = -1;
        if (n3 > 0) {
            stringArray[0] = "DES";
            n6 = n3 + string3.length();
        } else if (n4 > 0) {
            stringArray[0] = "3DES_EDE";
            n6 = n4 + string4.length();
        } else {
            throw new JSAFE_InvalidKeyException("Not a valid SSL-C PEM encoded RSA private key, missing encryption algorithm indicator expected either " + string3 + " or " + string4);
        }
        int n7 = n5 * 2;
        String string6 = string5.substring(n6, n6 + n7);
        byte[] byArray4 = JA_SSLCKeyEncode.hexStringToByteArray(string6);
        System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
        n6 += n7;
        while (JA_SSLCKeyEncode.isSpace(string5.charAt(n6))) {
            ++n6;
        }
        int n8 = string5.indexOf("-----END RSA PRIVATE KEY-----", n6);
        if (n8 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSL-C key, missing footer");
        }
        int n9 = n8 - n6;
        int n10 = n8;
        while (JA_SSLCKeyEncode.isSpace(string5.charAt(n10 - 1))) {
            --n9;
            --n10;
        }
        String string7 = string5.substring(n6, n10);
        try {
            byArray3 = string7.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string7.getBytes();
        }
        if (byArray3.length != n9) {
            System.err.println("ERROR");
        }
        return byArray3;
    }

    public static void decodeASN1Len(byte[] byArray, int n2, int[] nArray) throws JSAFE_InvalidKeyException {
        if ((byArray[n2] & 0x80) == 0) {
            nArray[0] = 1;
            nArray[1] = byArray[n2];
            return;
        }
        int n3 = byArray[n2] & 0x7F;
        if (n3 > 5) {
            throw new JSAFE_InvalidKeyException("Invalid SSL-C key, too may octets");
        }
        int n4 = 1;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ++n4;
            int n6 = byArray[n2 + 1 + i2] & 0xFF;
            n5 += n6 << 8 * (n3 - i2 - 1);
        }
        nArray[0] = n4;
        nArray[1] = n5;
    }

    static int[] a(byte[] byArray, int n2) throws JSAFE_InvalidUseException {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidUseException("Cannot build the PKCS #8 unencrypted key: " + aSN_Exception.getMessage());
        }
        int[] nArray = new int[]{octetStringContainer.dataOffset, octetStringContainer.dataLen};
        return nArray;
    }

    public static byte[] convertPKCS8ToPKCS1(byte[] byArray) throws JSAFE_InvalidKeyException {
        int n2;
        int n3 = 1;
        int n4 = byArray.length - 1;
        int[] nArray = new int[]{0, 0};
        JA_SSLCKeyEncode.decodeASN1Len(byArray, n3, nArray);
        n3 += nArray[0];
        n4 -= nArray[0];
        for (n2 = 0; n2 < 2; ++n2) {
            --n4;
            JA_SSLCKeyEncode.decodeASN1Len(byArray, ++n3, nArray);
            n3 += nArray[0] + nArray[1];
            n4 -= nArray[0] + nArray[1];
        }
        --n4;
        JA_SSLCKeyEncode.decodeASN1Len(byArray, ++n3, nArray);
        JA_SSLCKeyEncode.decodeASN1Len(byArray, (n3 += nArray[0]) + 1, nArray);
        n2 = nArray[1] + nArray[0] + 1;
        if (n2 != (n4 -= nArray[0])) {
            throw new RuntimeException("FATAL ERROR: dataLen = " + n4 + ", but computed len = " + n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] extractIV(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = null;
        String[] stringArray = new String[1];
        byte[] byArray3 = new byte[8];
        byArray2 = JA_SSLCKeyEncode.pemDecodeEncrypted(byArray, stringArray, byArray3);
        return byArray3;
    }

    public static byte[] convertPKCS1ToPKCS8(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = new byte[]{2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4};
        int n2 = byArray.length;
        byte[] byArray3 = JA_SSLCKeyEncode.encodeASN1Len(n2);
        int n3 = byArray2.length + byArray3.length + byArray.length;
        byte[] byArray4 = JA_SSLCKeyEncode.encodeASN1Len(n3);
        byte[] byArray5 = new byte[1 + byArray4.length + n3];
        int n4 = 0;
        byArray5[n4++] = 48;
        System.arraycopy(byArray4, 0, byArray5, n4, byArray4.length);
        System.arraycopy(byArray2, 0, byArray5, n4 += byArray4.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, n4 += byArray2.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray5, n4 += byArray3.length, byArray.length);
        n4 += byArray.length;
        return byArray5;
    }

    public static byte[] encodeASN1Len(int n2) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        if (n2 < 128) {
            byArray = new byte[]{(byte)n2};
        } else if (n2 < 255) {
            byArray = new byte[]{-127, (byte)n2};
        } else if (n2 < 65535) {
            byArray = new byte[]{-126, (byte)(n2 >> 8), (byte)n2};
        } else {
            throw new JSAFE_InvalidKeyException("key length is too big");
        }
        return byArray;
    }

    public static String decodeSSLCEncodedKey(byte[] byArray, int n2, byte[] byArray2) throws JSAFE_InvalidKeyException {
        String[] stringArray = new String[1];
        byte[] byArray3 = JA_SSLCKeyEncode.pemDecodeEncrypted(byArray, stringArray, byArray2);
        String string = "PBE/MD5/" + stringArray[0] + "/CBC/SSLCPBE";
        return string;
    }

    public static final String byteArrayToHexString(byte[] byArray, int n2, int n3) {
        return Utils.byteArrayToHexString(byArray, n2, n3);
    }

    public static final byte[] hexStringToByteArray(String string) {
        return Utils.hexStringToByteArray(string);
    }
}

