/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.spi.pki.ProtectInfo;

public final class CMPProtectInfo
extends ProtectInfo {
    private static final String a = "PBE/HMAC/SHA1/PKIXPBE-1024";
    boolean b;
    private String c = null;
    private X509Certificate d = null;
    private X509Certificate e = null;
    private char[] f = null;
    private byte[] g = null;
    private X509Certificate[] h = null;
    private DatabaseService i = null;

    public CMPProtectInfo(String string, Certificate certificate, Certificate certificate2, Certificate[] certificateArray, DatabaseService databaseService) throws InvalidParameterException {
        this.b = false;
        if (string == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: algorithm should not be null.");
        }
        this.c = string;
        if (!(certificate instanceof X509Certificate)) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: senderCert should be an instance of X509Certificate.");
        }
        this.d = (X509Certificate)certificate;
        if (certificate2 != null) {
            if (!(certificate2 instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: recipCert should be an instance of X509Certificate.");
            }
            this.e = (X509Certificate)certificate2;
        }
        if (databaseService == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: database should not be null.");
        }
        this.i = databaseService;
        this.a(certificateArray, true);
    }

    public CMPProtectInfo(String string, char[] cArray, byte[] byArray, Certificate certificate, Certificate[] certificateArray, DatabaseService databaseService) throws InvalidParameterException {
        this.b = true;
        this.c = string == null ? a : string;
        if (cArray == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: sharedSecret should not be null.");
        }
        this.f = cArray;
        if (byArray == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: keyID should not be null.");
        }
        this.g = byArray;
        if (certificate != null) {
            if (!(certificate instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: recipCert should be an instance of X509Certificate.");
            }
            this.e = (X509Certificate)certificate;
        }
        this.a(certificateArray, false);
        this.i = databaseService;
    }

    private void a(Certificate[] certificateArray, boolean bl2) throws InvalidParameterException {
        if (bl2 && (certificateArray == null || certificateArray.length == 0)) {
            throw new InvalidParameterException("CMPProtectInfo.setCACerts: caCerts should not be empty.");
        }
        if (certificateArray == null) {
            return;
        }
        this.h = new X509Certificate[certificateArray.length];
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            Certificate certificate = certificateArray[i2];
            if (!(certificate instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.setCACerts: every member of the caCerts array should be an instance of X509Certificate.");
            }
            this.h[i2] = (X509Certificate)certificateArray[i2];
        }
    }

    protected boolean pbmProtected() {
        return this.b;
    }

    protected String getAlgorithm() {
        return this.c;
    }

    protected X509Certificate getSenderCert() {
        return this.d;
    }

    protected X509Certificate getRecipCert() {
        return this.e;
    }

    protected X509Certificate[] getCACerts() {
        return this.h;
    }

    protected char[] getSharedSecret() {
        return this.f;
    }

    protected byte[] getKeyID() {
        return this.g;
    }

    protected DatabaseService getDatabase() {
        return this.i;
    }
}

