/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.ArchiveCutoff;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.BiometricInfo;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.CRLNumber;
import com.rsa.certj.cert.extensions.CRLReference;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.CertificateIssuer;
import com.rsa.certj.cert.extensions.DeltaCRLIndicator;
import com.rsa.certj.cert.extensions.ExtendedKeyUsage;
import com.rsa.certj.cert.extensions.HoldInstructionCode;
import com.rsa.certj.cert.extensions.InhibitAnyPolicy;
import com.rsa.certj.cert.extensions.InvalidityDate;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.IssuingDistributionPoint;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.NetscapeBaseURL;
import com.rsa.certj.cert.extensions.NetscapeCAPolicyURL;
import com.rsa.certj.cert.extensions.NetscapeCARevocationURL;
import com.rsa.certj.cert.extensions.NetscapeCertRenewalURL;
import com.rsa.certj.cert.extensions.NetscapeCertType;
import com.rsa.certj.cert.extensions.NetscapeComment;
import com.rsa.certj.cert.extensions.NetscapeRevocationURL;
import com.rsa.certj.cert.extensions.NetscapeSSLServerName;
import com.rsa.certj.cert.extensions.NonStandardExtension;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNoCheck;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.OCSPServiceLocator;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyMappings;
import com.rsa.certj.cert.extensions.PrivateKeyUsagePeriod;
import com.rsa.certj.cert.extensions.QCStatements;
import com.rsa.certj.cert.extensions.ReasonCode;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectDirectoryAttributes;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.VeriSignCZAG;
import com.rsa.certj.cert.extensions.VeriSignFidelityUniqueID;
import com.rsa.certj.cert.extensions.VeriSignJurisdictionHash;
import com.rsa.certj.cert.extensions.VeriSignNetscapeInBoxV1;
import com.rsa.certj.cert.extensions.VeriSignNetscapeInBoxV2;
import com.rsa.certj.cert.extensions.VeriSignNonVerifiedElements;
import com.rsa.certj.cert.extensions.VeriSignSerialNumberRollover;
import com.rsa.certj.cert.extensions.VeriSignTokenType;
import java.io.Serializable;
import java.util.Vector;

public abstract class X509V3Extension
implements Cloneable,
Serializable {
    protected String extensionTypeString;
    protected static final int OID_BYTE_ONE = 85;
    protected static final int OID_BYTE_TWO = 29;
    public static final int SUBJECT_KEY_ID = 14;
    public static final int AUTHORITY_KEY_ID = 35;
    public static final int KEY_USAGE = 15;
    public static final int PRIVATE_KEY_USAGE_PERIOD = 16;
    public static final int SUBJECT_ALT_NAME = 17;
    public static final int ISSUER_ALT_NAME = 18;
    public static final int BASIC_CONSTRAINTS = 19;
    public static final int SUBJECT_DIRECTORY_ATTRIBUTES = 9;
    public static final int NAME_CONSTRAINTS = 30;
    public static final int CERT_POLICIES = 32;
    public static final int POLICY_MAPPINGS = 33;
    public static final int POLICY_CONSTRAINTS = 36;
    public static final int EXTENDED_KEY_USAGE = 37;
    public static final int CRL_NUMBER = 20;
    public static final int REASON_CODE = 21;
    public static final int HOLD_INSTRUCTION_CODE = 23;
    public static final int INVALIDITY_DATE = 24;
    public static final int DELTA_CRL_INDICATOR = 27;
    public static final int ISSUING_DISTRIBUTION_POINT = 28;
    public static final int CERTIFICATE_ISSUER = 29;
    public static final int CRL_DISTRIBUTION_POINTS = 31;
    public static final int INHIBIT_ANY_POLICY = 54;
    private static final int a = 100;
    public static final int AUTHORITY_INFO_ACCESS = 100;
    public static final byte[] AUTHORITY_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 1};
    public static final int NETSCAPE_CERT_TYPE = 101;
    public static final byte[] NETSCAPE_CERT_TYPE_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 1};
    public static final int NETSCAPE_BASE_URL = 102;
    public static final byte[] NETSCAPE_BASE_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 2};
    public static final int NETSCAPE_REVOCATION_URL = 103;
    public static final byte[] NETSCAPE_REVOCATION_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 3};
    public static final int NETSCAPE_CA_REVOCATION_URL = 104;
    public static final byte[] NETSCAPE_CA_REVOCATION_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 4};
    public static final int NETSCAPE_CERT_RENEWAL_URL = 105;
    public static final byte[] NETSCAPE_CERT_RENEWAL_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 7};
    public static final int NETSCAPE_CA_POLICY_URL = 106;
    public static final byte[] NETSCAPE_CA_POLICY_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 8};
    public static final int NETSCAPE_SSL_SERVER_NAME = 107;
    public static final byte[] NETSCAPE_SSL_SERVER_NAME_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 12};
    public static final int NETSCAPE_COMMENT = 108;
    public static final byte[] NETSCAPE_COMMENT_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 13};
    public static final int VERISIGN_CZAG = 109;
    public static final byte[] VERISIGN_CZAG_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 3};
    public static final int VERISIGN_FIDELITY_ID = 110;
    public static final byte[] VERISIGN_FIDELITY_ID_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 5};
    public static final int VERISIGN_NETSCAPE_INBOX_V1 = 111;
    public static final byte[] VERISIGN_NETSCAPE_INBOX_V1_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 6};
    public static final int VERISIGN_NETSCAPE_INBOX_V2 = 112;
    public static final byte[] VERISIGN_NETSCAPE_INBOX_V2_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 10};
    public static final int VERISIGN_JURISDICTION_HASH = 113;
    public static final byte[] VERISIGN_JURISDICTION_HASH_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 11};
    public static final int VERISIGN_TOKEN_TYPE = 114;
    public static final byte[] VERISIGN_TOKEN_TYPE_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 8};
    public static final int VERISIGN_SERIAL_NUMBER = 115;
    public static final byte[] VERISIGN_SERIAL_NUMBER_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 7};
    public static final int VERISIGN_NON_VERIFIED = 116;
    public static final byte[] VERISIGN_NON_VERIFIED_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 4};
    public static final int OCSP_NOCHECK = 117;
    public static final byte[] OCSP_NOCHECK_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 5};
    public static final int ARCHIVE_CUTOFF = 118;
    public static final byte[] ARCHIVE_CUTOFF_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 6};
    public static final int CRL_REFERENCE = 119;
    public static final byte[] CRL_REFERENCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 3};
    public static final int OCSP_NONCE = 120;
    public static final byte[] OCSP_NONCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 2};
    public static final int OCSP_ACCEPTABLE_RESPONSES = 121;
    public static final byte[] OCSP_ACCEPTABLE_RESPONSES_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 4};
    public static final int OCSP_SERVICE_LOCATOR = 122;
    public static final byte[] OCSP_SERVICE_LOCATOR_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 7};
    public static final int QC_STATEMENTS = 123;
    public static final byte[] QC_STATEMENTS_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 3};
    public static final int BIO_INFO = 124;
    public static final byte[] BIO_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 2};
    public static final int NON_STANDARD_EXTENSION = -1;
    private static final int[] b = new int[]{14, 35, 15, 16, 17, 18, 19, 9, 30, 32, 33, 36, 37, 20, 21, 23, 24, 27, 28, 29, 31, 54, -1};
    private static final byte[][] c = new byte[][]{AUTHORITY_INFO_OID, NETSCAPE_CERT_TYPE_OID, NETSCAPE_BASE_URL_OID, NETSCAPE_REVOCATION_URL_OID, NETSCAPE_CA_REVOCATION_URL_OID, NETSCAPE_CERT_RENEWAL_URL_OID, NETSCAPE_CA_POLICY_URL_OID, NETSCAPE_SSL_SERVER_NAME_OID, NETSCAPE_COMMENT_OID, VERISIGN_CZAG_OID, VERISIGN_FIDELITY_ID_OID, VERISIGN_NETSCAPE_INBOX_V1_OID, VERISIGN_NETSCAPE_INBOX_V2_OID, VERISIGN_JURISDICTION_HASH_OID, VERISIGN_TOKEN_TYPE_OID, VERISIGN_SERIAL_NUMBER_OID, VERISIGN_NON_VERIFIED_OID, OCSP_NOCHECK_OID, ARCHIVE_CUTOFF_OID, CRL_REFERENCE_OID, OCSP_NONCE_OID, OCSP_ACCEPTABLE_RESPONSES_OID, OCSP_SERVICE_LOCATOR_OID, QC_STATEMENTS_OID, BIO_INFO_OID};
    private static Vector d = new Vector();
    private static Vector e = new Vector();
    protected boolean criticality;
    protected int extensionTypeFlag;
    byte[] f;
    int g;
    protected int special;
    protected ASN1Template asn1Template;
    protected byte[] extEncoding = null;

    public static void extend(byte[] byArray, X509V3Extension x509V3Extension) throws CertificateException {
        if (byArray == null || x509V3Extension == null) {
            throw new CertificateException("X509V3Extension.extend: neither oid nor extension should be null.");
        }
        if (X509V3Extension.a(byArray)) {
            throw new CertificateException("X509V3Extension.extend: oid is already in use.");
        }
        X509V3Extension x509V3Extension2 = X509V3Extension.a(byArray, 0, byArray.length);
        if (x509V3Extension2 == null) {
            d.addElement(byArray);
            e.addElement(x509V3Extension);
        } else if (!x509V3Extension.getClass().isInstance(x509V3Extension2)) {
            throw new CertificateException("X509V3Extension.extend: there exists an extended extension using the same OID.");
        }
    }

    private static boolean a(byte[] byArray) {
        return X509V3Extension.b(byArray) || X509V3Extension.c(byArray);
    }

    private static boolean b(byte[] byArray) {
        if (byArray.length != 3) {
            return false;
        }
        if (byArray[0] != 85) {
            return false;
        }
        if (byArray[1] != 29) {
            return false;
        }
        for (int i2 = 0; i2 < b.length; ++i2) {
            if (byArray[2] != b[i2]) continue;
            return true;
        }
        return false;
    }

    private static boolean c(byte[] byArray) {
        int n2 = byArray.length;
        for (int i2 = 0; i2 < c.length; ++i2) {
            byte[] byArray2 = c[i2];
            if (!X509V3Extension.a(byArray2, byArray, 0, n2)) continue;
            return true;
        }
        return false;
    }

    private static X509V3Extension a(byte[] byArray, int n2, int n3) throws CertificateException {
        int n4 = d.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray2 = (byte[])d.elementAt(i2);
            if (!X509V3Extension.a(byArray2, byArray, n2, n3)) continue;
            try {
                return (X509V3Extension)((X509V3Extension)e.elementAt(i2)).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CertificateException("X509V3Extension.findExtendedExtension: extended extension should support clone method(" + cloneNotSupportedException.getMessage() + ").");
            }
        }
        return null;
    }

    private static boolean a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (byArray.length != n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] == byArray2[n2 + i2]) continue;
            return false;
        }
        return true;
    }

    public static X509V3Extension getInstance(byte[] byArray, int n2) throws CertificateException {
        X509V3Extension x509V3Extension;
        ASN1Container[] aSN1ContainerArray;
        block53: {
            if (byArray == null) {
                throw new CertificateException("Encoding is null.");
            }
            aSN1ContainerArray = X509V3Extension.decodeExtension(byArray, n2);
            int n3 = X509V3Extension.b(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, aSN1ContainerArray[1].dataLen);
            x509V3Extension = null;
            switch (n3) {
                case 14: {
                    x509V3Extension = new SubjectKeyID();
                    break;
                }
                case 35: {
                    x509V3Extension = new AuthorityKeyID();
                    break;
                }
                case 15: {
                    x509V3Extension = new KeyUsage();
                    break;
                }
                case 16: {
                    x509V3Extension = new PrivateKeyUsagePeriod();
                    break;
                }
                case 17: {
                    x509V3Extension = new SubjectAltName();
                    break;
                }
                case 18: {
                    x509V3Extension = new IssuerAltName();
                    break;
                }
                case 19: {
                    x509V3Extension = new BasicConstraints();
                    break;
                }
                case 9: {
                    x509V3Extension = new SubjectDirectoryAttributes();
                    break;
                }
                case 30: {
                    x509V3Extension = new NameConstraints();
                    break;
                }
                case 32: {
                    x509V3Extension = new CertPolicies();
                    break;
                }
                case 33: {
                    x509V3Extension = new PolicyMappings();
                    break;
                }
                case 36: {
                    x509V3Extension = new PolicyConstraints();
                    break;
                }
                case 37: {
                    x509V3Extension = new ExtendedKeyUsage();
                    break;
                }
                case 20: {
                    x509V3Extension = new CRLNumber();
                    break;
                }
                case 21: {
                    x509V3Extension = new ReasonCode();
                    break;
                }
                case 23: {
                    x509V3Extension = new HoldInstructionCode();
                    break;
                }
                case 24: {
                    x509V3Extension = new InvalidityDate();
                    break;
                }
                case 27: {
                    x509V3Extension = new DeltaCRLIndicator();
                    break;
                }
                case 28: {
                    x509V3Extension = new IssuingDistributionPoint();
                    break;
                }
                case 29: {
                    x509V3Extension = new CertificateIssuer();
                    break;
                }
                case 31: {
                    x509V3Extension = new CRLDistributionPoints();
                    break;
                }
                case 54: {
                    x509V3Extension = new InhibitAnyPolicy();
                    break;
                }
                case 100: {
                    x509V3Extension = new AuthorityInfoAccess();
                    break;
                }
                case 101: {
                    x509V3Extension = new NetscapeCertType();
                    break;
                }
                case 102: {
                    x509V3Extension = new NetscapeBaseURL();
                    break;
                }
                case 103: {
                    x509V3Extension = new NetscapeRevocationURL();
                    break;
                }
                case 104: {
                    x509V3Extension = new NetscapeCARevocationURL();
                    break;
                }
                case 105: {
                    x509V3Extension = new NetscapeCertRenewalURL();
                    break;
                }
                case 106: {
                    x509V3Extension = new NetscapeCAPolicyURL();
                    break;
                }
                case 107: {
                    x509V3Extension = new NetscapeSSLServerName();
                    break;
                }
                case 108: {
                    x509V3Extension = new NetscapeComment();
                    break;
                }
                case 109: {
                    x509V3Extension = new VeriSignCZAG();
                    break;
                }
                case 110: {
                    x509V3Extension = new VeriSignFidelityUniqueID();
                    break;
                }
                case 111: {
                    x509V3Extension = new VeriSignNetscapeInBoxV1();
                    break;
                }
                case 112: {
                    x509V3Extension = new VeriSignNetscapeInBoxV2();
                    break;
                }
                case 113: {
                    x509V3Extension = new VeriSignJurisdictionHash();
                    break;
                }
                case 114: {
                    x509V3Extension = new VeriSignTokenType();
                    break;
                }
                case 115: {
                    x509V3Extension = new VeriSignSerialNumberRollover();
                    break;
                }
                case 116: {
                    x509V3Extension = new VeriSignNonVerifiedElements();
                    break;
                }
                case 117: {
                    x509V3Extension = new OCSPNoCheck();
                    break;
                }
                case 118: {
                    x509V3Extension = new ArchiveCutoff();
                    break;
                }
                case 119: {
                    x509V3Extension = new CRLReference();
                    break;
                }
                case 120: {
                    x509V3Extension = new OCSPNonce();
                    break;
                }
                case 121: {
                    x509V3Extension = new OCSPAcceptableResponses();
                    break;
                }
                case 122: {
                    x509V3Extension = new OCSPServiceLocator();
                    break;
                }
                case 123: {
                    x509V3Extension = new QCStatements();
                    break;
                }
                case 124: {
                    x509V3Extension = new BiometricInfo();
                    break;
                }
                case -1: {
                    x509V3Extension = X509V3Extension.a(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, aSN1ContainerArray[1].dataLen);
                    if (x509V3Extension != null) break;
                    x509V3Extension = new NonStandardExtension();
                    x509V3Extension.f = new byte[aSN1ContainerArray[1].dataLen];
                    System.arraycopy(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, x509V3Extension.f, 0, aSN1ContainerArray[1].dataLen);
                    break;
                }
                default: {
                    throw new CertificateException("Unknown extension.");
                }
            }
            x509V3Extension.setCriticality(((BooleanContainer)aSN1ContainerArray[2]).value);
            try {
                x509V3Extension.setEncoding(aSN1ContainerArray[3].data, aSN1ContainerArray[3].dataOffset, aSN1ContainerArray[3].dataLen);
                x509V3Extension.decodeValue(aSN1ContainerArray[3].data, aSN1ContainerArray[3].dataOffset);
            }
            catch (CertificateException certificateException) {
                if (!x509V3Extension.getCriticality()) break block53;
                throw new CertificateException(certificateException.getMessage());
            }
        }
        x509V3Extension.setOID(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, aSN1ContainerArray[1].dataLen);
        return x509V3Extension;
    }

    public void setEncoding(byte[] byArray, int n2, int n3) {
        this.extEncoding = new byte[n3];
        System.arraycopy(byArray, n2, this.extEncoding, 0, n3);
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return n2 + ASN1Lengths.determineLength(byArray, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    protected static ASN1Container[] decodeExtension(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        BooleanContainer booleanContainer = new BooleanContainer(131072);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, booleanContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot read the BER of the extension.");
        }
        return aSN1ContainerArray;
    }

    protected void setOID(byte[] byArray, int n2, int n3) {
    }

    public void setStandardOID(int n2) {
        this.f = new byte[3];
        this.f[0] = 85;
        this.f[1] = 29;
        this.f[2] = (byte)n2;
        this.g = 3;
    }

    public void setSpecialOID(byte[] byArray) {
        if (byArray != null) {
            this.g = byArray.length;
            this.f = new byte[this.g];
            System.arraycopy(byArray, 0, this.f, 0, this.g);
        }
    }

    private static int b(byte[] byArray, int n2, int n3) {
        if (n3 == 3 && (byArray[n2] & 0xFF) == 85 && (byArray[n2 + 1] & 0xFF) == 29) {
            int n4 = byArray[n2 + 2] & 0xFF;
            int n5 = 0;
            do {
                if (n4 != b[n5]) continue;
                return n4;
            } while (b[++n5] != -1);
            return -1;
        }
        for (int i2 = 0; i2 < c.length; ++i2) {
            if (!X509V3Extension.a(c[i2], 0, c[i2].length, byArray, n2, n3)) continue;
            return 100 + i2;
        }
        return -1;
    }

    private static boolean a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (n3 != n5) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2 + n2] == byArray2[i2 + n4]) continue;
            return false;
        }
        return true;
    }

    public void setCriticality(boolean bl2) {
        if (bl2 == this.criticality) {
            return;
        }
        this.criticality = bl2;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public abstract void decodeValue(byte[] var1, int var2) throws CertificateException;

    public int getExtensionType() {
        return this.extensionTypeFlag;
    }

    public String getExtensionTypeString() {
        return this.extensionTypeString;
    }

    public boolean isExtensionType(int n2) {
        return n2 == this.extensionTypeFlag;
    }

    public int getDERLen(int n2) {
        if (this.extEncoding != null) {
            return this.derEncodeExtensionLen(n2, this.extEncoding.length);
        }
        return this.derEncodeExtensionLen(n2, this.derEncodeValueInit());
    }

    public abstract int derEncodeValueInit();

    public int getDEREncoding(byte[] byArray, int n2, int n3) {
        if (byArray == null || n2 < 0) {
            return 0;
        }
        return this.derEncodeExtension(byArray, n2, n3);
    }

    protected int derEncodeExtensionLen(int n2, int n3) {
        this.special = n2;
        try {
            BooleanContainer booleanContainer = null;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, this.f, 0, this.g);
            booleanContainer = !this.criticality ? new BooleanContainer(131072, false, 0, this.criticality) : new BooleanContainer(131072, true, 0, this.criticality);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, null, 0, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, booleanContainer, octetStringContainer, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeExtension(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return 0;
        }
        if ((this.asn1Template == null || this.special != n3) && this.getDERLen(n3) == 0) {
            return 0;
        }
        int n4 = 0;
        try {
            n4 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
        if (this.extEncoding != null) {
            if (byArray.length - (n2 + n4) < this.extEncoding.length) {
                return 0;
            }
            System.arraycopy(this.extEncoding, 0, byArray, n2 + n4, this.extEncoding.length);
            return this.extEncoding.length + n4;
        }
        n4 += this.derEncodeValue(byArray, n2 + n4);
        return n4;
    }

    public abstract int derEncodeValue(byte[] var1, int var2);

    public abstract Object clone() throws CloneNotSupportedException;

    protected void copyValues(X509V3Extension x509V3Extension) {
        if (x509V3Extension == null) {
            return;
        }
        x509V3Extension.criticality = this.criticality;
        if (this.f != null) {
            x509V3Extension.f = (byte[])this.f.clone();
            x509V3Extension.g = this.g;
        }
        x509V3Extension.special = this.special;
        if (this.asn1Template != null) {
            x509V3Extension.getDERLen(this.special);
        }
    }

    protected void reset() {
        this.asn1Template = null;
    }

    protected byte[] intToByteArray(int n2) {
        int n3 = n2 >>> 24;
        int n4 = n2 >>> 16 & 0xFF;
        int n5 = n2 >>> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        byte[] byArray = n3 != 0 ? new byte[]{(byte)n3, (byte)n4, (byte)n5, (byte)n6} : (n4 != 0 ? new byte[]{(byte)n4, (byte)n5, (byte)n6} : (n5 != 0 ? new byte[]{(byte)n5, (byte)n6} : new byte[]{(byte)n6}));
        return byArray;
    }

    protected int byteArrayToInt(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            n2 = (n2 << 8) + (by2 & 0xFF);
        }
        return n2;
    }
}

