/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class KeyUsage
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    public static final int KEY_USAGE_BITS = 9;
    public static final int KEY_USAGE_MASK = -8388608;
    public static final int DIGITAL_SIGNATURE = Integer.MIN_VALUE;
    public static final int NON_REPUDIATION = 0x40000000;
    public static final int KEY_ENCIPHERMENT = 0x20000000;
    public static final int DATA_ENCIPHERMENT = 0x10000000;
    public static final int KEY_AGREEMENT = 0x8000000;
    public static final int KEY_CERT_SIGN = 0x4000000;
    public static final int CRL_SIGN = 0x2000000;
    public static final int ENCIPHER_ONLY = 0x1000000;
    public static final int DECIPHER_ONLY = 0x800000;
    private int a;
    ASN1Template b;

    public KeyUsage() {
        this.extensionTypeFlag = 15;
        this.criticality = false;
        this.setStandardOID(15);
        this.extensionTypeString = "KeyUsage";
    }

    public KeyUsage(int n2, boolean bl2) {
        this.extensionTypeFlag = 15;
        this.criticality = bl2;
        this.a = n2 & 0xFF800000;
        this.setStandardOID(15);
        this.extensionTypeString = "KeyUsage";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a = 0;
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode KeyUsage extension.");
        }
        if (bitStringContainer.dataLen == 0) {
            return;
        }
        if (bitStringContainer.dataLen > 4) {
            throw new CertificateException("Could not decode KeyUsage extension.");
        }
        int n3 = bitStringContainer.dataOffset;
        int n4 = 24;
        while (n3 < bitStringContainer.dataOffset + bitStringContainer.dataLen) {
            this.a |= (bitStringContainer.data[n3] & 0xFF) << n4;
            ++n3;
            n4 -= 8;
        }
        this.a &= 0xFF800000;
    }

    public int getKeyUsage() {
        return this.a;
    }

    public boolean verifyKeyUsage(int n2) {
        int n3 = n2 & this.a & 0xFF800000;
        return n3 == n2;
    }

    public int derEncodeValueInit() {
        BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, this.a, 9, true);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        this.b = new ASN1Template(aSN1ContainerArray);
        try {
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyUsage keyUsage = new KeyUsage();
        keyUsage.a = this.a;
        if (this.b != null) {
            keyUsage.derEncodeValueInit();
        }
        super.copyValues(keyUsage);
        return keyUsage;
    }

    protected void reset() {
        super.reset();
        this.a = 0;
        this.b = null;
    }
}

