/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.PersonalName;
import java.io.Serializable;
import java.util.Vector;

public class BuiltInStandardAttributes
implements Cloneable,
Serializable {
    private ORName a = null;
    private ORName b = null;
    private String c = null;
    private String d = null;
    private ORName e = null;
    private String f = null;
    private String g = null;
    private PersonalName h = null;
    private String[] i = new String[4];
    private int j = 0;
    protected int special;
    protected ASN1Template asn1Template = null;

    public BuiltInStandardAttributes(byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n3);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(0x410001);
            EncodedContainer encodedContainer2 = new EncodedContainer(4259842);
            NumericStringContainer numericStringContainer = new NumericStringContainer(0x810000, 1, 16);
            PrintStringContainer printStringContainer = new PrintStringContainer(0x810001, 1, 24);
            EncodedContainer encodedContainer3 = new EncodedContainer(8454146);
            PrintStringContainer printStringContainer2 = new PrintStringContainer(8454147, 1, 64);
            NumericStringContainer numericStringContainer2 = new NumericStringContainer(8454148, 1, 32);
            EncodedContainer encodedContainer4 = new EncodedContainer(8466693);
            EncodedContainer encodedContainer5 = new EncodedContainer(8466438);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, numericStringContainer, printStringContainer, encodedContainer3, printStringContainer2, numericStringContainer2, encodedContainer4, encodedContainer5, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                this.a = new ORName(0, encodedContainer.data, encodedContainer.dataOffset, 0);
            }
            if (encodedContainer2.dataPresent) {
                this.b = new ORName(1, encodedContainer2.data, encodedContainer2.dataOffset, 0);
            }
            if (numericStringContainer.dataPresent) {
                this.c = numericStringContainer.getValueAsString();
            }
            if (printStringContainer.dataPresent) {
                this.d = printStringContainer.getValueAsString();
            }
            if (encodedContainer3.dataPresent) {
                this.e = new ORName(2, encodedContainer3.data, encodedContainer3.dataOffset, 8454146);
            }
            if (printStringContainer2.dataPresent) {
                this.f = printStringContainer2.getValueAsString();
            }
            if (numericStringContainer2.dataPresent) {
                this.g = numericStringContainer2.getValueAsString();
            }
            if (encodedContainer4.dataPresent) {
                this.h = new PersonalName(encodedContainer4.data, encodedContainer4.dataOffset, 8454149);
            }
            if (encodedContainer5.dataPresent) {
                OfContainer ofContainer = new OfContainer(8454150, 12288, new EncodedContainer(4864));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode(encodedContainer5.data, encodedContainer5.dataOffset, aSN1ContainerArray2);
                int n4 = ofContainer.getContainerCount();
                if (n4 > 4) {
                    throw new NameException("Too many entries in OrganizationalUnitNanes: MAX number is 4.");
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    ASN1Container aSN1Container = ofContainer.containerAt(i2);
                    PrintStringContainer printStringContainer3 = new PrintStringContainer(0, 1, 32);
                    ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{printStringContainer3};
                    ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray3);
                    this.i[this.j] = printStringContainer3.getValueAsString();
                    ++this.j;
                }
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the BuiltInStandardAttributes.");
        }
    }

    public BuiltInStandardAttributes() {
    }

    public void setCountryName(ORName oRName) throws NameException {
        if (oRName == null) {
            throw new NameException("Specified value is null.");
        }
        if (oRName.getNameType() != 0) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.a = oRName;
    }

    public void setAdminDomainName(ORName oRName) throws NameException {
        if (oRName == null) {
            throw new NameException("Specified value is null.");
        }
        if (oRName.getNameType() != 1) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.b = oRName;
    }

    public void setNetworkAddress(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 16) {
            throw new NameException("Specified value is too long.");
        }
        this.c = new String(string);
    }

    public void setTerminalIdentifier(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 24) {
            throw new NameException("Specified value is too long.");
        }
        this.d = new String(string);
    }

    public void setPrivateDomainName(ORName oRName) throws NameException {
        if (oRName == null) {
            throw new NameException("Specified value is null.");
        }
        if (oRName.getNameType() != 2) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.e = oRName;
    }

    public void setOrganizationName(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 64) {
            throw new NameException("Specified value is too long.");
        }
        this.f = new String(string);
    }

    public void setNumericUserIdentifier(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 32) {
            throw new NameException("Specified value is too long.");
        }
        this.g = new String(string);
    }

    public void setPersonalName(PersonalName personalName) {
        if (personalName != null) {
            this.h = personalName;
        }
    }

    public void setOrganizationalUnitNames(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 32) {
            throw new NameException("Specified value is too long.");
        }
        if (this.j == 4) {
            throw new NameException("Cannot add Organizational Unit Names attribute: MAX number is 4");
        }
        this.i[this.j] = new String(string);
        ++this.j;
    }

    public ORName getCountryName() {
        return this.a;
    }

    public ORName getAdminDomainName() {
        return this.b;
    }

    public String getNetworkAddress() {
        return this.c;
    }

    public String getTerminalIdentifier() {
        return this.d;
    }

    public ORName getPrivateDomainName() {
        return this.e;
    }

    public String getOrganizationName() {
        return this.f;
    }

    public String getNumericUserIdentifier() {
        return this.g;
    }

    public PersonalName getPersonalName() {
        return this.h;
    }

    public String[] getOrganizationalUnitNames() {
        return this.i;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a.toString());
        }
        if (this.b != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.b.toString());
        }
        if (this.c != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.c);
        }
        if (this.d != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.d);
        }
        if (this.e != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.e.toString());
        }
        if (this.f != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.f);
        }
        if (this.g != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.g);
        }
        if (this.h != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.h.toString());
        }
        for (int i2 = 0; i2 < this.j; ++i2) {
            stringBuffer.append(",");
            stringBuffer.append(this.i[i2]);
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4 = 0;
            if ((this.asn1Template == null || n3 != this.special) && (n4 = this.getDERLen(n3)) == 0) {
                throw new NameException("Unable to encode BuiltInStandardAttributes");
            }
            int n5 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n5;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode BuiltInStandardAttributes");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            Object object;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(sequenceContainer);
            int n2 = 0;
            byte[] byArray = null;
            if (this.a != null) {
                n2 = this.a.getDERLen(65536);
                byArray = new byte[n2];
                n2 = this.a.getDEREncoding(byArray, 0, 65536);
                object = new EncodedContainer(65536, true, 0, byArray, 0, n2);
                vector.addElement(object);
            }
            if (this.b != null) {
                n2 = this.b.getDERLen(65536);
                byArray = new byte[n2];
                n2 = this.b.getDEREncoding(byArray, 0, 65536);
                object = new EncodedContainer(65536, true, 0, byArray, 0, n2);
                vector.addElement(object);
            }
            if (this.c != null) {
                object = new NumericStringContainer(0x810000, true, 0, this.c, 1, 16);
                vector.addElement(object);
            }
            if (this.d != null) {
                object = new PrintStringContainer(0x810001, true, 0, this.d, 1, 24);
                vector.addElement(object);
            }
            if (this.e != null) {
                n2 = this.e.getDERLen(8454146);
                byArray = new byte[n2];
                n2 = this.e.getDEREncoding(byArray, 0, 8454146);
                object = new EncodedContainer(8454146, true, 0, byArray, 0, n2);
                vector.addElement(object);
            }
            if (this.f != null) {
                object = new PrintStringContainer(8454147, true, 0, this.f, 1, 64);
                vector.addElement(object);
            }
            if (this.g != null) {
                object = new NumericStringContainer(8454148, true, 0, this.g, 1, 32);
                vector.addElement(object);
            }
            if (this.h != null) {
                n2 = this.h.getDERLen(8454149);
                byArray = new byte[n2];
                n2 = this.h.getDEREncoding(byArray, 0, 8454149);
                object = new EncodedContainer(8454149, true, 0, byArray, 0, n2);
                vector.addElement(object);
            }
            if (this.j != 0) {
                vector.addElement(this.b());
            }
            vector.addElement(endContainer);
            object = new ASN1Container[vector.size()];
            vector.copyInto((Object[])object);
            this.asn1Template = new ASN1Template((ASN1Container[])object);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    private EncodedContainer b() throws NameException {
        EncodedContainer encodedContainer = null;
        EncodedContainer encodedContainer2 = null;
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            Object object;
            Object object2;
            OfContainer ofContainer = new OfContainer(8454150, true, 0, 12288, new EncodedContainer(4864));
            vector.addElement(ofContainer);
            for (int i2 = 0; i2 < this.j; ++i2) {
                object2 = new PrintStringContainer(0, true, 0, this.i[i2], 1, 32);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2};
                object = new ASN1Template(aSN1ContainerArray);
                int n2 = ((ASN1Template)object).derEncodeInit();
                byte[] byArray = new byte[n2];
                n2 = ((ASN1Template)object).derEncode(byArray, 0);
                encodedContainer2 = new EncodedContainer(4864, true, 0, byArray, 0, n2);
                ofContainer.addContainer(encodedContainer2);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            object2 = new ASN1Template((ASN1Container[])objectArray);
            int n3 = ((ASN1Template)object2).derEncodeInit();
            object = new byte[n3];
            n3 = ((ASN1Template)object2).derEncode((byte[])object, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, (byte[])object, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(" Can't encode Organizational Unit Names.");
        }
        return encodedContainer;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BuiltInStandardAttributes)) {
            return false;
        }
        BuiltInStandardAttributes builtInStandardAttributes = (BuiltInStandardAttributes)object;
        if (this.j != builtInStandardAttributes.j) {
            return false;
        }
        if (this.a != null ? !this.a.equals(builtInStandardAttributes.a) : builtInStandardAttributes.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(builtInStandardAttributes.b) : builtInStandardAttributes.b != null) {
            return false;
        }
        if (this.c != null ? !this.c.equals(builtInStandardAttributes.c) : builtInStandardAttributes.c != null) {
            return false;
        }
        if (this.d != null ? !this.d.equals(builtInStandardAttributes.d) : builtInStandardAttributes.d != null) {
            return false;
        }
        if (this.e != null ? !this.e.equals(builtInStandardAttributes.e) : builtInStandardAttributes.e != null) {
            return false;
        }
        if (this.f != null ? !this.f.equals(builtInStandardAttributes.f) : builtInStandardAttributes.f != null) {
            return false;
        }
        if (this.g != null ? !this.g.equals(builtInStandardAttributes.g) : builtInStandardAttributes.g != null) {
            return false;
        }
        if (this.h != null ? !this.h.equals(builtInStandardAttributes.h) : builtInStandardAttributes.h != null) {
            return false;
        }
        for (int i2 = 0; i2 < this.j; ++i2) {
            if (this.i[i2].equals(builtInStandardAttributes.i[i2])) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        BuiltInStandardAttributes builtInStandardAttributes = new BuiltInStandardAttributes();
        builtInStandardAttributes.j = this.j;
        if (this.a != null) {
            builtInStandardAttributes.a = (ORName)this.a.clone();
        }
        if (this.b != null) {
            builtInStandardAttributes.b = (ORName)this.b.clone();
        }
        if (this.c != null) {
            builtInStandardAttributes.c = new String(this.c);
        }
        if (this.d != null) {
            builtInStandardAttributes.d = new String(this.d);
        }
        if (this.e != null) {
            builtInStandardAttributes.e = (ORName)this.e.clone();
        }
        if (this.f != null) {
            builtInStandardAttributes.f = new String(this.f);
        }
        if (this.g != null) {
            builtInStandardAttributes.g = new String(this.g);
        }
        if (this.h != null) {
            builtInStandardAttributes.h = (PersonalName)this.h.clone();
        }
        for (int i2 = 0; i2 < this.j; ++i2) {
            builtInStandardAttributes.i[i2] = new String(this.i[i2]);
        }
        builtInStandardAttributes.special = this.special;
        if (this.asn1Template != null) {
            builtInStandardAttributes.a();
        }
        return builtInStandardAttributes;
    }
}

