/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class PNGWriter {
    private final CRC32 m_crc32 = new CRC32();
    private final DataOutputStream m_out;

    public PNGWriter(OutputStream out) throws IOException {
        this.m_out = new DataOutputStream(out);
        this.m_out.writeLong(-8552249625308161526L);
    }

    public void writeChunk(PNGChunk chunk) throws IOException {
        if (chunk.type.length != 4) {
            throw new IOException("bad length");
        }
        this.m_crc32.reset();
        int length = chunk.data == null ? 0 : chunk.data.length;
        this.m_out.writeInt(length);
        this.m_out.write(chunk.type, 0, chunk.type.length);
        this.m_crc32.update(chunk.type);
        if (length > 0) {
            this.m_out.write(chunk.data, 0, chunk.data.length);
            this.m_crc32.update(chunk.data);
        }
        long computedCRC = this.m_crc32.getValue();
        this.m_out.writeInt((int)computedCRC);
    }
}

