/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

public class PNGChunk {
    private static final String LATIN_1_ENCODING = "ISO-8859-1";
    public final byte[] type;
    public final String typeStr;
    public final byte[] data;

    public PNGChunk(byte[] type, byte[] data) {
        this(type, PNGChunk.cvt(type), data);
    }

    public PNGChunk(String type, byte[] data) {
        this(PNGChunk.cvt(type), type, data);
    }

    private PNGChunk(byte[] type, String typeStr, byte[] data) {
        if (type == null || type.length != 4) {
            throw new IllegalArgumentException("type");
        }
        if (typeStr == null || typeStr.length() != 4 || typeStr.charAt(0) > '\u00ff' || typeStr.charAt(1) > '\u00ff' || typeStr.charAt(2) > '\u00ff' || typeStr.charAt(3) > '\u00ff') {
            throw new IllegalArgumentException("type");
        }
        this.type = type;
        this.typeStr = typeStr.intern();
        this.data = data;
    }

    static byte[] cvt(String type) {
        try {
            return type.getBytes(LATIN_1_ENCODING);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("type");
        }
    }

    static String cvt(byte[] type) {
        try {
            return new String(type, LATIN_1_ENCODING);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("type");
        }
    }
}

