/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.Utils;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.File;
import java.io.IOException;

public abstract class MacPackager
extends NativePackager {
    public MacPackager() {
        super("MacOS-x86", true, false);
    }

    protected String getPlatformConverterName() {
        return ENTRYPOINT_NAME;
    }

    protected void parseDescriptorValues() throws IOException {
        try {
            this.m_applicationDescriptor = new ApplicationDescriptor(new File(this.m_conversionOutput, "Contents/Resources/META-INF/AIR/application.xml"));
            this.m_appName = this.m_applicationDescriptor.filename();
        }
        catch (DescriptorValidationException e2) {
            throw new IllegalStateException("Conversion produced an invalid descriptor");
        }
    }

    protected void copyWithPermissions(File source, File dest) throws IOException {
        Process copy = new ProcessBuilder("rsync", "-a", source.getPath(), dest.getPath()).start();
        Utils.consumeOutput(copy);
        try {
            copy.waitFor();
        }
        catch (InterruptedException e2) {
            throw new IOException("Copy Interrupted");
        }
        if (copy.exitValue() != 0) {
            throw new IOException("Copy failed");
        }
    }
}

