/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.InvalidInputException;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.ProcessError;
import com.adobe.air.ipa.SWFUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SWFSplitter {
    public static void main(String[] args) throws IOException, ProcessError {
        File optsSerFile = new File(args[0]);
        AOTCompilerOptions opts = null;
        try {
            opts = (AOTCompilerOptions)AOTCompiler.readObject(optsSerFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(5);
        }
        String inputSwf = opts.rootSwf.getPath();
        String outputSwf = args[1];
        String abcDir = args[2];
        try {
            SWFUtils util = new SWFUtils(new FileInputStream(inputSwf), opts.compressSWF, true);
            if (opts.verbosity > 0 && opts.optLevel > 0 && util.getABCs().size() > 100) {
                System.out.println("Too many ABC files in swf - " + util.getABCs().size() + " You are probably using a debug / un-optimized swf");
            }
            int index = 0;
            for (byte[] abcData : util.getABCs()) {
                File temp = SWFSplitter.getNewTempFile(abcDir, opts.baseName + "-" + String.format("%010d", index) + ".abc");
                FileOutputStream fop = new FileOutputStream(temp);
                fop.write(abcData);
                fop.flush();
                fop.close();
                ++index;
            }
            util.exportToFile(new File(outputSwf));
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new InvalidInputException("Invalid input. Not a valid swf file");
        }
    }

    public static File getNewTempFile(String tempFolder, String path) throws IOException {
        File rFile = new File(tempFolder, path);
        if (rFile.exists()) {
            rFile.delete();
        }
        rFile.createNewFile();
        return rFile;
    }
}

