/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.AIROutputStream;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class AIRPackager
extends ApplicationPackager {
    public static final ApplicationDescriptor.ValidationParams AIR_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/1.0", null, new String[]{"desktop", "mobileDevice", "extendedMobileDevice", "tv"}, true, false);
    public static final ApplicationDescriptor.ValidationParams AIRI_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/1.0", "http://ns.adobe.com/air/application/2.5", new String[0], true, true);
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";

    protected AIRPackager(boolean allowAppBundledExtensions, boolean allowDeviceBundledExtensions) {
        this("ALL", allowAppBundledExtensions, allowDeviceBundledExtensions);
    }

    protected AIRPackager(String platform, boolean allowAppBundledExtensions, boolean allowDeviceBundledExtensions) {
        super("AIR", platform, allowAppBundledExtensions, allowDeviceBundledExtensions);
        this.setStream(this.newStream());
    }

    protected AIROutputStream newStream() {
        return new AIROutputStream();
    }

    public AIRPackager() {
        this(false, false);
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.validateSigningCertificate(certchain);
        super.setCertificateChain(certchain);
    }

    public void setApplicationDescriptor(File descriptorFile) {
        if (this.m_airiFile != null) {
            throw new IllegalStateException(".airi input already set");
        }
        super.setApplicationDescriptor(descriptorFile);
    }

    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return this.m_sign ? AIR_VALIDATION_PARAMS : AIRI_VALIDATION_PARAMS;
    }

    public void setDescriptor(File descriptorFile) {
        this.setApplicationDescriptor(descriptorFile);
    }

    public void createIntermediate() throws IOException {
        this.m_sign = false;
        this.setAllowAppBundledExtensions(true);
        this.setAllowDeviceBundledExtensions(true);
        try {
            this.createPackage();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("certificate exception with signing disabled");
        }
    }

    public void createAIR() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    public File getIntermediate() {
        return this.m_airiFile;
    }

    protected void validateApplicationDescriptor() throws DescriptorValidationException {
        try {
            this.m_applicationDescriptor = new ApplicationDescriptor(this.m_applicationDescriptorFile, this.m_validate);
            if (this.m_validate) {
                this.getApplicationDescriptor().validate(this.getValidationParams(this.m_applicationDescriptor), this.getSources());
            }
        }
        catch (DescriptorValidationException e2) {
            if (this.m_listener != null) {
                this.m_listener.message(e2.getFirstMessage());
            }
            throw e2;
        }
    }

    protected String getMimetype() {
        if (this.m_sign) {
            return "application/vnd.adobe.air-application-installer-package+zip";
        }
        return "application/vnd.adobe.air-application-intermediate-package+zip";
    }

    protected void addSpecialFiles() throws IOException {
        this.getStream().addMimeTypeFile(this.getMimetype(), this.m_sign);
        super.addSpecialFiles();
        this.getStream().addHashFile("META-INF/AIR/hash");
        if (this.m_debug) {
            this.getStream().addDebugFile("META-INF/AIR/debug", this.m_sign);
        }
    }

    public void setAIRFile(File airFile) {
        throw new IllegalStateException("Tried to set an air file as input on an AIRPackager");
    }

    protected AIROutputStream getStream() {
        return (AIROutputStream)super.getStream();
    }

    public void validate() {
        block2: {
            try {
                ApplicationDescriptor appDescriptor = new ApplicationDescriptor(this.m_applicationDescriptorFile);
                appDescriptor.validate(this.getValidationParams(appDescriptor), this.getSources());
            }
            catch (DescriptorValidationException e2) {
                if (this.m_listener == null) break block2;
                this.m_listener.message(e2.getFirstMessage());
            }
        }
    }

    public void addMetaWithPath(File source, String path) {
        super.addMetaWithPath(source, path);
    }

    public void addMetaFileOrDir(File file, File root, String prefixPath) {
        super.addMetaFileOrDir(file, root, prefixPath);
    }
}

