/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.BuiltinDomain;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.TypeAnalysis;
import adobe.abc.Typeref;

public class Binding {
    final GlobalOptimizer.InputAbc abc;
    private final Name name;
    int flags_kind;
    int slot;
    int id;
    private Object value;
    Typeref type;
    Method method;
    GlobalOptimizer.Metadata[] md = OptimizerConstants.nometadata;
    Binding peer = null;

    Binding(int kind, Name name, GlobalOptimizer.InputAbc abc) {
        this.name = name;
        this.flags_kind = kind;
        this.abc = abc;
    }

    public boolean hasSlot() {
        return this.slot != 0;
    }

    public int kind() {
        return this.flags_kind & 0xF;
    }

    public boolean isFinal() {
        return (this.flags_kind >> 4 & 0x1001) != 0;
    }

    public void setLocallyFinal() {
        this.flags_kind |= 0x10000;
    }

    public void clearLocallyFinal() {
        this.flags_kind &= 0xFFFEFFFF;
    }

    public boolean isOverride() {
        return (this.flags_kind >> 4 & 2) != 0;
    }

    public boolean hasMetadata() {
        return (this.flags_kind >> 4 & 4) != 0;
    }

    public boolean isConst() {
        return this.kind() == 6 || this.kind() == 2;
    }

    public boolean isClass() {
        return this.kind() == 4;
    }

    public boolean isMethod() {
        int tk = this.kind();
        return tk == 1;
    }

    public boolean isGetter() {
        int tk = this.kind();
        return tk == 2;
    }

    public boolean isSetter() {
        int tk = this.kind();
        return tk == 3;
    }

    public boolean isSlot() {
        int tk = this.kind();
        return tk == 0 || tk == 6 || tk == 4;
    }

    public boolean methodFromObjectOrClass() {
        return this.method != null && (this.method.cx.equals(BuiltinDomain.instance().OBJECT()) || this.method.cx.equals(BuiltinDomain.instance().CLASS()));
    }

    public boolean defaultValueChanged() {
        if (this.type.t.defaultValue != null) {
            return !this.type.t.defaultValue.equals(this.value);
        }
        return this.value != null;
    }

    public String toString() {
        switch (this.kind()) {
            case 4: {
                return "[" + this.slot + "] [" + this.getName().format() + "] class";
            }
            case 0: {
                return "[" + this.slot + "] [" + this.getName().format() + "] var";
            }
            case 6: {
                return "[" + this.slot + "] [" + this.getName().format() + "] const";
            }
            case 1: {
                return "[" + this.slot + "] [" + this.getName().format() + "] method";
            }
            case 2: {
                return "[" + this.slot + "] [" + this.getName().format() + "] get";
            }
            case 3: {
                return "[" + this.slot + "] [" + this.getName().format() + "] set";
            }
        }
        assert (false);
        return null;
    }

    public Name getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object value() {
        Object v2 = this.value;
        if (v2 != null && this.type != null) {
            BuiltinDomain bd2 = BuiltinDomain.instance();
            Type t2 = this.type.getType();
            if (t2 == bd2.UINT()) {
                return TypeAnalysis.eval_convert_u(v2);
            }
            if (t2 == bd2.INT()) {
                return TypeAnalysis.eval_convert_i(v2);
            }
            if (t2 == bd2.STRING()) {
                return TypeAnalysis.eval_coerce_s(v2);
            }
            if (t2 == bd2.NUMBER()) {
                return TypeAnalysis.eval_convert_d(v2);
            }
        }
        return v2;
    }
}

