package cn.gtmap.realestate.supervise.common;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2017/6/14
 * @description 用户信息初始化类
 */
@Controller
public class BaseInfoController {

    @Value("${region.qhdm}")
    private String regionQhdm;

    @Value("${platform.cookiename}")
    private String platformCookiename;

    @Autowired(required = false)
    private SecuritySSOHandleService securitySSOHandleService;

    //获取行政区列表
    public String getRegionName() {
        String qhdm = AppConfig.getProperty("region.qhdm");
        if (StringUtils.isEmpty(qhdm)) {
            qhdm = regionQhdm;
        }
        XtRegion xtRegion;
        String regionName = "";
        if (StringUtils.isNotBlank(qhdm)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            xtRegion = securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion) {
                regionName = xtRegion.getQhmc();
            }
        }
        return regionName;
    }

    //根据行政区代码获取名称
    public List<XtRegion> getRegionLst() {
        String qhdm = AppConfig.getProperty("region.qhdm");
        if (StringUtils.isEmpty(qhdm)) {
            qhdm = regionQhdm;
        }
        List<XtRegion> regionList = new ArrayList<>();
        if (StringUtils.isNotBlank(qhdm)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            regionList = securitySSOHandleService.getXzqhNext(qhdm);
        }
        return regionList;
    }

    //根据行政区代码获取名称
    public List<XtRegion> getCurrRegionLst(String userid) {
        List<XtRegion> regionList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            regionList = securitySSOHandleService.getCurruserRegion(userid);
        }
        return regionList;
    }


    //获取当前用户最大的行政区代码
    public XtRegion getMaxRegion(String userid) {
        XtRegion xtRegion = new XtRegion();
        if (StringUtils.isNotBlank(userid)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            xtRegion = securitySSOHandleService.getMaxRegion(userid);
        }
        return xtRegion;
    }


    //根据行政区代码获取名称
    public List<XtGroup> getCurrGroupLst(String userid) {
        List<XtGroup> groupList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            groupList = securitySSOHandleService.getCurruserGroup(userid);
        }
        return groupList;
    }

    public UserAuthDTO getCurrentUser(HttpServletRequest request) {

        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserAuthDTO userAuthDTO = null;
        if (null == authentication) {
            String cookieName = AppConfig.getProperty("platform.cookiename");
            if (StringUtils.isEmpty(cookieName)) {
                cookieName = platformCookiename;
            }
            Cookie[] diskCookies = request.getCookies();
            String cookieValue;
            if (diskCookies != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (diskCookies[i].getName().equals(cookieName)) {
                        cookieValue = diskCookies[i].getValue();
                        if (securitySSOHandleService == null) {
                            securitySSOHandleService = new SecuritySSOHandleServiceImpl();
                        }
                        userAuthDTO = securitySSOHandleService.validUser(cookieValue);
                    }
                }
            }
        } else {
            Object obj = authentication.getPrincipal();
            if (null != obj && obj instanceof UserAuthDTO) {
                userAuthDTO = (UserAuthDTO) obj;
                userAuthDTO.getAuthorities();
            }
        }
        return userAuthDTO;
    }

    //获取获取区划级别
    public String getQhjb() {
        String qhdm = AppConfig.getProperty("region.qhdm");
        if (StringUtils.isEmpty(qhdm)) {
            qhdm = regionQhdm;
        }
        XtRegion xtRegion;
        String qhjb = "";
        if (StringUtils.isNotBlank(qhdm)) {
            if (securitySSOHandleService == null) {
                securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            xtRegion = securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion) {
                qhjb = xtRegion.getQhjb();
            }
        }
        return qhjb;
    }

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param userAuthDTO 用户认证对象
     * @return
     * @description 根据用户信息获取区划代码
     */
    public String getQhdmByUserAuthDTO(UserAuthDTO userAuthDTO) {
        String qhdm = "";
        if(userAuthDTO != null) {
            Map<String, Object> regionMap = null;
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if(CollectionUtils.isNotEmpty(regionList)) {
                regionMap = regionList.get(0);
            }
            if(regionMap != null) {
                qhdm = CommonUtil.formatEmptyValue(regionMap.get("qhdm"));
            }
        }
        return qhdm;
    }

    /**
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 验证是否是大市，是否是省直辖的县区，用于查询中条件
     */
    public String getQhjbByQhdm(String qhdm){
        String qhjb = "";
        String szxRegons = AppConfig.getProperty("sjpt.containsSxs.dwdm");
        if (StringUtils.isNotBlank(szxRegons) && szxRegons.contains(qhdm)) {
            qhjb = "";
        } else {
            XtRegion xtRegion = securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion){
                qhjb = xtRegion.getQhjb();
            }
        }
        return qhjb;
    }

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param qhdm 区划代码
     * @return
     * @description 根据区划代码获取行政区划列表信息
     */
    public List<XtRegion> getXtRegionList(String qhdm, String level) {
        return securitySSOHandleService.getLevelXzqh(qhdm,level);
    }

}
