/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.HtmlRegexpUtil;
import cn.gtmap.realestate.supervise.utils.XssAndSqlHttpServletResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class XssAndSqlResponseFilter
implements Filter {
    private String ResponsePages;
    private String[] ResponsePagesArrary;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ResponsePages = filterConfig.getInitParameter("ResponsePages");
        if (StringUtils.isNotEmpty((CharSequence)this.ResponsePages)) {
            this.ResponsePagesArrary = this.ResponsePages.split(",");
        }
        if (null != this.ResponsePagesArrary && this.ResponsePagesArrary.length != 0) {
            for (int i = 0; i < this.ResponsePagesArrary.length; ++i) {
                this.ResponsePagesArrary[i] = StringUtils.trim((String)this.ResponsePagesArrary[i]);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String url = httpRequest.getServletPath();
        boolean isResponsedPage = false;
        if (null != this.ResponsePagesArrary && this.ResponsePagesArrary.length != 0) {
            for (String page : this.ResponsePagesArrary) {
                if (!url.equals(page)) continue;
                isResponsedPage = true;
                break;
            }
        }
        if (isResponsedPage) {
            XssAndSqlHttpServletResponseWrapper wrapResponse = new XssAndSqlHttpServletResponseWrapper((HttpServletResponse)servletResponse);
            chain.doFilter(request, (ServletResponse)wrapResponse);
            byte[] data = wrapResponse.getResponseData();
            String resp_old_str = new String(data, "UTF-8");
            HtmlRegexpUtil hu = new HtmlRegexpUtil();
            String newResult = hu.replaceTag(resp_old_str);
            ServletOutputStream out = servletResponse.getOutputStream();
            byte[] b = newResult.getBytes("UTF-8");
            out.write(b);
            out.flush();
            out.close();
        } else {
            chain.doFilter(request, servletResponse);
        }
    }

    public void destroy() {
    }
}

