/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClient(String url, Map<String, String> paramMap) throws IOException {
        block13: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                Set<String> keySet = paramMap.keySet();
                if (!CollectionUtils.isNotEmpty(keySet)) break block13;
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpClient IOException!{}", (Throwable)e);
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e2);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClient(String url, Map<String, Object> paramMap, Map<String, String> headers, String min) throws IOException {
        block15: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                Set<String> headersKeySet = headers.keySet();
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                logger.info(url + "RequestBody:{}", (Object)JSON.toJSONString(paramMap));
                if (StringUtils.isNotBlank((CharSequence)min)) {
                    int milS = Integer.parseInt(min) * 60 * 1000;
                    httpClient.setTimeout(milS);
                    httpClient.setConnectionTimeout(milS);
                }
                if (CollectionUtils.isNotEmpty(headersKeySet)) {
                    for (String key : headersKeySet) {
                        postMethod.addRequestHeader(key, headers.get(key));
                    }
                }
                logger.info(url + "RequestHeaders:{}", (Object)JSON.toJSONString((Object)postMethod.getRequestHeaders()));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpClient IOException!{}", (Throwable)e);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClient(String url, Map<String, String> paramMap, Cookie[] cookies) throws IOException {
        block15: {
            PostMethod postMethod = new PostMethod(url);
            if (null != cookies && cookies.length != 0) {
                StringBuffer cookieStr = new StringBuffer();
                for (int i = 0; i < cookies.length; ++i) {
                    cookieStr.append(cookies[i].getName());
                    cookieStr.append("=");
                    cookieStr.append(cookies[i].getValue()).append(";");
                }
                postMethod.setRequestHeader("Cookie", cookieStr.toString());
            }
            Set<String> keySet = paramMap.keySet();
            try {
                String string;
                if (!CollectionUtils.isNotEmpty(keySet)) break block15;
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            e.printStackTrace();
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClient(String url, Cookie[] cookies) throws IOException {
        block14: {
            PostMethod postMethod = new PostMethod(url);
            if (null != cookies && cookies.length != 0) {
                StringBuffer cookieStr = new StringBuffer();
                for (int i = 0; i < cookies.length; ++i) {
                    cookieStr.append(cookies[i].getName());
                    cookieStr.append("=");
                    cookieStr.append(cookies[i].getValue()).append(";");
                }
                postMethod.setRequestHeader("Cookie", cookieStr.toString());
            }
            try {
                String string;
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            e.printStackTrace();
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e2);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpDataClient(String url, Map<String, Object> paramMap) throws IOException {
        block12: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                Set<String> keySet = paramMap.keySet();
                if (!CollectionUtils.isNotEmpty(keySet)) break block12;
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpDataClient IOException!{}", (Throwable)e);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpDataClient Exception!{}", (Throwable)e2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpDataGBKClient(String url, Map<String, Object> paramMap) throws IOException {
        block12: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                Set<String> keySet = paramMap.keySet();
                if (!CollectionUtils.isNotEmpty(keySet)) break block12;
                postMethod.setRequestHeader("Content-Type", "application/json;charset=GBK");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "GBK"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpDataClient IOException!{}", (Throwable)e);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpDataClient Exception!{}", (Throwable)e2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpObjectClient(String url, Object object) throws IOException {
        block12: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                if (object == null) break block12;
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString((Object)object));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, postMethod.getResponseCharSet()));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpObjectClient IOException!{}", (Throwable)e);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpObjectClient Exception!{}", (Throwable)e2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClientJson(String min, String url, Map<String, Object> paramMap) throws IOException {
        block13: {
            PostMethod postMethod = new PostMethod(url);
            try {
                String string;
                Set<String> keySet = paramMap.keySet();
                if (StringUtils.isNotBlank((CharSequence)min)) {
                    int milS = Integer.parseInt(min) * 60 * 1000;
                    httpClient.setTimeout(milS);
                    httpClient.setConnectionTimeout(milS);
                }
                if (!CollectionUtils.isNotEmpty(keySet)) break block13;
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = null;
                try {
                    inputStream = postMethod.getResponseBodyAsStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuffer json = new StringBuffer();
                    String str = "";
                    while ((str = br.readLine()) != null) {
                        json.append(str);
                    }
                    string = json.toString();
                }
                catch (IOException e) {
                    try {
                        try {
                            logger.error("HttpClientUtil.sendHttpClientJson IOException!{}", (Throwable)e);
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", (Throwable)e2);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                inputStream.close();
                return string;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpClient(String url) throws IOException {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)url)) {
            GetMethod getMethod = new GetMethod(url);
            InputStream inputStream = null;
            try {
                httpClient.executeMethod((HttpMethod)getMethod);
                inputStream = getMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                String string = json.toString();
                return string;
            }
            catch (IOException e) {
                logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", (Throwable)e);
            }
            finally {
                inputStream.close();
                getMethod.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostHttpClient(String url) throws IOException {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)url)) {
            PostMethod postMethod = new PostMethod(url);
            InputStream inputStream = null;
            try {
                httpClient.executeMethod((HttpMethod)postMethod);
                inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                String string = json.toString();
                return string;
            }
            catch (IOException e) {
                logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", (Throwable)e);
            }
            finally {
                inputStream.close();
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    static {
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(500000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(600000);
        httpClient.getHttpConnectionManager().getParams().setDefaultMaxConnectionsPerHost(50);
        httpClient.getHttpConnectionManager().getParams().setMaxTotalConnections(200);
        httpClient.getParams().setConnectionManagerTimeout(10000L);
        httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                return executionCount < 3;
            }
        });
    }
}

