package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.constant.Constant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @version 1.0 2019-6-27
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public class XssFilterUtil {

    private static final Logger log = LoggerFactory.getLogger(XssFilterUtil.class);

    private static List<Pattern> PATTERNS = null;

    private static String REGEX="[\n`~!@#%^&*+=':;'\\[\\]<>?~！@#￥%……&*——+]";
    private static Pattern PATTERN = Pattern.compile(REGEX);

    /**
     *
     * @return
     */
    private static List<Object[]> getXssPatternList() {

        List<Object[]> ret = new ArrayList<Object[]>();

        ret.add(new Object[]{"<(no)?script[^>]*>.*?</(no)?script>", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"</script>", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"<script(.*?)>", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"img\\((.*?)\\)", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"email\\((.*?)\\)", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"eval\\((.*?)\\)", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"expression\\((.*?)\\)", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"<(\"[^\"]*\"|\'[^\']*\'|[^\'\">])*>", Pattern.CASE_INSENSITIVE});
        ret.add(new Object[]{"<+\\s*\\w*\\s*(alert|oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror=|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatechange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+\\s*=+", Pattern.CASE_INSENSITIVE});
        return ret;
    }

    /**
     * @param
     * @return java.util.List<java.util.regex.Pattern>
     * @Title: XSS常见攻击-正则表达式
     * @methodName: getPatterns
     * @Description:
     * @date: 2019-01-25 9:11
     */
    private static List<Pattern> getPatterns() {


        if (PATTERNS == null) {

            List<Pattern> list = new ArrayList<Pattern>();

            String regex = null;
            Integer flag = null;
            int arrLength = 0;

            for (Object[] arr : getXssPatternList()) {
                arrLength = arr.length;
                for (int i = 0; i < arrLength; i++) {
                    regex = (String) arr[0];
                    flag = (Integer) arr[1];
                    list.add(Pattern.compile(regex, flag));
                }
            }

            PATTERNS = list;
        }

        return PATTERNS;
    }

    /**
     * XXS 字符串替换
     * @param value
     * @param request
     * @return
     */
    public static String stripXss(String value, ServletRequest request) {
        String url = ((HttpServletRequest)request).getServletPath();
        if (StringUtils.isNotBlank(value)) {

            Matcher matcher = null;

            for (Pattern pattern : getPatterns()) {
                matcher = pattern.matcher(value);
                // 匹配
                if (matcher.find()) {
                    log.info("【XSS攻击防御】，接收字符是：{}", value);
                    // 删除相关字符串
                    value = matcher.replaceAll("");
                    OperationalLogUtil.log((HttpServletRequest) request,"0"
                        ,url + "含有非法字符", Constant.PORTAL);
                    log.info("【XSS攻击防御】，匹配正则是：{}，处理后是：{}", matcher, value);
                }
            }

            /**
             * 替换为转移字符，类似HtmlUtils.htmlEscape
             */

            if (StringUtils.isNotBlank(value)) {
                if (PATTERN.matcher(value).find()) {
                    log.info("【XSS攻击防御】，接收字符是：{}", value);
                    value = PATTERN.matcher(value).replaceAll("").trim();
                    OperationalLogUtil.log((HttpServletRequest) request,"0"
                        ,url + "含有非法字符", Constant.PORTAL);
                    log.info("【XSS攻击防御】，特殊符号处理后是：{}", value);
                }
            }

        }

        return value;
    }

    /**
     * XXS 字符串替换
     * @param value
     * @return
     */
    public static String stripXss(String value) {
        if (StringUtils.isNotBlank(value)) {

            Matcher matcher = null;

            for (Pattern pattern : getPatterns()) {
                matcher = pattern.matcher(value);
                // 匹配
                if (matcher.find()) {
                    log.info("【XSS攻击防御】，接收字符是：{}", value);
                    // 删除相关字符串
                    value = matcher.replaceAll("");
                    log.info("【XSS攻击防御】，匹配正则是：{}，处理后是：{}", matcher, value);
                }
            }

            /**
             * 替换为转移字符，类似HtmlUtils.htmlEscape
             */

            if (StringUtils.isNotBlank(value)) {
                if (PATTERN.matcher(value).find()) {
                    log.info("【XSS攻击防御】，接收字符是：{}", value);
                    value = PATTERN.matcher(value).replaceAll("").trim();
                    log.info("【XSS攻击防御】，特殊符号处理后是：{}", value);
                }
            }

        }

        return value;
    }

    /**
     * XXS 字符串替换
     * @param value
     * @return
     */
    public static String stripXssRes(String value) {
        if (StringUtils.isNotBlank(value)) {

            Matcher matcher = null;

            for (Pattern pattern : getPatterns()) {
                matcher = pattern.matcher(value);
                // 匹配
                if (matcher.find()) {
                    log.info("【XSS攻击防御】，接收字符是：{}", value);
                    // 删除相关字符串
                    value = matcher.replaceAll("");
                    log.info("【XSS攻击防御】，匹配正则是：{}，处理后是：{}", matcher, value);
                }
            }

        }

        return value;
    }
}
