package cn.gtmap.realestate.supervise.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by user on 2019/7/2.
 */
public class XssAndSqlResponseFilter implements Filter {

    private String ResponsePages; //要对response进行拦截的url
    private String[] ResponsePagesArrary; //要对response进行拦截的url


    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        ResponsePages = filterConfig.getInitParameter("ResponsePages");
        if (StringUtils.isNotEmpty(ResponsePages)) {
            ResponsePagesArrary = ResponsePages.split(",");
        }
        if (null!= ResponsePagesArrary && ResponsePagesArrary.length!= 0) {
            for(int i = 0; i < ResponsePagesArrary.length; i++) {
                ResponsePagesArrary[i] = StringUtils.trim(ResponsePagesArrary[i]);
            }
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        String url = httpRequest.getServletPath();
        boolean isResponsedPage = false;
        if(null != ResponsePagesArrary && ResponsePagesArrary.length != 0) {
            for (String page : ResponsePagesArrary) {//判断是否在过滤url之外
                if (url.equals(page)) {
                    isResponsedPage = true;
                    break;
                }
            }
        }
        if (isResponsedPage) {
            XssAndSqlHttpServletResponseWrapper wrapResponse = new XssAndSqlHttpServletResponseWrapper((HttpServletResponse) servletResponse);
            chain.doFilter(request, wrapResponse);
            byte[] data = wrapResponse.getResponseData();
            String resp_old_str = new String(data, "UTF-8"); //获得 json数据
            //将json数据转化成 map类型
            HtmlRegexpUtil hu = new HtmlRegexpUtil();//对json数据进行验证
            String newResult = hu.replaceTag(resp_old_str);//获得修改后的json数据
            ServletOutputStream out = servletResponse.getOutputStream();//吐出到客户端即浏览器
            byte[] b = (newResult).getBytes("UTF-8");
            out.write(b);
            out.flush();
            out.close();
        } else {
            chain.doFilter(request, servletResponse);
        }
    }


    @Override
    public void destroy() {

    }


}
