package cn.gtmap.realestate.supervise.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/10/10
 * @description 响应结果封装类
 */
public class GxRespListData {

    /**
     * 报文头
     */
    private Map<String, Object> head = new HashMap<>();

    public GxRespListData() {

    }

    public GxRespListData(Object code, String msg) {
        setValue("code", code);
        setValue("msg", msg);
    }

    /**
     * 报文体
     */
    private String data;

    public Map<String, Object> getHead() {
        return head;
    }

    public void setHead(Map<String, Object> head) {
        this.head = head;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMsg(String value) {
        setValue("msg", value);
    }

    public void setCode(String value) {
        setValue("code", value);
    }

    public void setTotal(int value) {
        setValue("total", value);
    }

    public void setRecords(int value) {
        setValue("records", value);
    }

    public void setPage(int value) {
        setValue("page", value);
    }

    public void setPageSize(int value) {
        setValue("pageSize", value);
    }

    private void setValue(String key, Object value) {
        Map head = this.head;
        head.put(key, value);
    }
}
