package cn.gtmap.realestate.supervise.entity.diji;

import cn.gtmap.realestate.supervise.core.reflect.id;
import cn.gtmap.realestate.supervise.core.reflect.jgbsm;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhangjingen
 * @version 1.0, 2025/11/25
 * @description 集体土地所有权宗地分类面积调查表属性结构
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
@XmlType
@Entity
@Table(
        name = "DIJI_JTTDSYQZDFLMJDCB"
)
public class DijiJttdsyqzdflmjdcb implements Serializable {

    @XmlAttribute
    @Id
    @id
    private String id;

    /**
     * 要素代码
     */
    @XmlAttribute
    private String ysdm;

    /**
     * 不动产单元号
     */
    @XmlAttribute
    private String bdcdyh;

    /**
     * 宗地代码
     */
    @XmlAttribute
    private String zddm;

    /**
     * 权利类型
     */
    @XmlAttribute
    private String qllx;

    /**
     * 面积单位
     */
    @XmlAttribute
    private String mjdw;

    /**
     * 农用地面积
     */
    @XmlAttribute
    private String nydmj;

    /**
     * 耕地面积
     */
    @XmlAttribute
    private String gdmj;

    /**
     * 林地面积
     */
    @XmlAttribute
    private String ldmj;

    /**
     * 草地面积
     */
    @XmlAttribute
    private String cdmj;

    /**
     * 其他农用地面积
     */
    @XmlAttribute
    private String qtnydmj;

    /**
     * 建设用地面积
     */
    @XmlAttribute
    private String jsydmj;

    /**
     * 未利用地面积
     */
    @XmlAttribute
    private String wlydmj;

    /**
     * 说明
     */
    @XmlAttribute
    private String sm;

    /**
     * 调查时间
     */
    @XmlAttribute
    private Date dcsj;

    /**
     * 区县代码
     */
    @XmlAttribute
    private String qxdm;

    /**
     * 集体土地所有权宗地分类面积调查表
     */
    @XmlAttribute
    private String jttdsyqzdflmjdcb;

    /**
     * 原不动产单元号
     */
    @XmlAttribute
    private String ybdcdyh;

    /** 监管标识码 */
    @jgbsm
    private String jgbsf;

    /** 登记状态 */
    @XmlAttribute
    private String djzt;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getYsdm() {
        return ysdm;
    }

    public void setYsdm(String ysdm) {
        this.ysdm = ysdm;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getZddm() {
        return zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    public String getNydmj() {
        return nydmj;
    }

    public void setNydmj(String nydmj) {
        this.nydmj = nydmj;
    }

    public String getGdmj() {
        return gdmj;
    }

    public void setGdmj(String gdmj) {
        this.gdmj = gdmj;
    }

    public String getLdmj() {
        return ldmj;
    }

    public void setLdmj(String ldmj) {
        this.ldmj = ldmj;
    }

    public String getCdmj() {
        return cdmj;
    }

    public void setCdmj(String cdmj) {
        this.cdmj = cdmj;
    }

    public String getQtnydmj() {
        return qtnydmj;
    }

    public void setQtnydmj(String qtnydmj) {
        this.qtnydmj = qtnydmj;
    }

    public String getJsydmj() {
        return jsydmj;
    }

    public void setJsydmj(String jsydmj) {
        this.jsydmj = jsydmj;
    }

    public String getWlydmj() {
        return wlydmj;
    }

    public void setWlydmj(String wlydmj) {
        this.wlydmj = wlydmj;
    }

    public String getSm() {
        return sm;
    }

    public void setSm(String sm) {
        this.sm = sm;
    }

    public Date getDcsj() {
        return dcsj;
    }

    public void setDcsj(Date dcsj) {
        this.dcsj = dcsj;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public String getJttdsyqzdflmjdcb() {
        return jttdsyqzdflmjdcb;
    }

    public void setJttdsyqzdflmjdcb(String jttdsyqzdflmjdcb) {
        this.jttdsyqzdflmjdcb = jttdsyqzdflmjdcb;
    }

    public String getYbdcdyh() {
        return ybdcdyh;
    }

    public void setYbdcdyh(String ybdcdyh) {
        this.ybdcdyh = ybdcdyh;
    }

    public String getJgbsf() {
        return jgbsf;
    }

    public void setJgbsf(String jgbsf) {
        this.jgbsf = jgbsf;
    }

    public String getDjzt() {
        return djzt;
    }

    public void setDjzt(String djzt) {
        this.djzt = djzt;
    }
}
