/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onething.util;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.exception.OnethingException;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PropertiesLoadUtil {
    public static final Logger log = Logger.getLogger(PropertiesLoadUtil.class);

    public static void loadFromContext() {
        Properties properties = new Properties();
        InputStream proStream = null;
        BufferedReader proBufferReader = null;
        try {
            proStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("onething.properties");
            if (proStream != null) {
                properties.load(proStream);
                for (String propertyName : properties.stringPropertyNames()) {
                    String propertyValue = properties.getProperty(propertyName);
                    Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
                    Matcher matcher = pattern.matcher(propertyValue);
                    StringBuffer buffer = new StringBuffer();
                    while (matcher.find()) {
                        String key = matcher.group(1);
                        String value = properties.getProperty(key);
                        if (value == null) {
                            log.error((Object)("Missing value for placeholder: " + key));
                        }
                        matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                    }
                    matcher.appendTail(buffer);
                    String newValue = buffer.toString();
                    properties.setProperty(propertyName, newValue);
                }
                System.getProperties().putAll((Map<?, ?>)properties);
            }
        }
        catch (Exception e) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u4e0a\u4e0b\u6587\u7c7b\u52a0\u8f7d\u5668-\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", e);
        }
        finally {
            try {
                if (proStream != null) {
                    proStream.close();
                }
                if (proBufferReader != null) {
                    proBufferReader.close();
                }
            }
            catch (Exception e) {
                throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u4e0a\u4e0b\u6587\u7c7b\u52a0\u8f7d\u5668-\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u6d41\u5173\u95ed\u5931\u8d25", e);
            }
        }
    }

    public static void loadProperties(String propertiesParentPath) {
        Properties properties = new Properties();
        InputStream proStream = null;
        BufferedReader proBufferReader = null;
        try {
            boolean exist = new File(propertiesParentPath + File.separator + "onething.properties").exists();
            if (exist) {
                proStream = new BufferedInputStream(new FileInputStream(propertiesParentPath + File.separator + "onething.properties"));
                proBufferReader = new BufferedReader(new InputStreamReader(proStream, "UTF-8"));
                properties.load(proBufferReader);
                for (String propertyName : properties.stringPropertyNames()) {
                    String propertyValue = properties.getProperty(propertyName);
                    Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
                    Matcher matcher = pattern.matcher(propertyValue);
                    StringBuffer buffer = new StringBuffer();
                    while (matcher.find()) {
                        String key = matcher.group(1);
                        String value = properties.getProperty(key);
                        if (value == null) {
                            log.error((Object)("Missing value for placeholder: " + key));
                        }
                        matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                    }
                    matcher.appendTail(buffer);
                    String newValue = buffer.toString();
                    properties.setProperty(propertyName, newValue);
                }
                System.getProperties().putAll((Map<?, ?>)properties);
            } else {
                PropertiesLoadUtil.loadFromContext();
            }
        }
        catch (Exception e) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u901a\u8fc7\u8def\u5f84-\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", e);
        }
        finally {
            try {
                if (proStream != null) {
                    proStream.close();
                }
                if (proBufferReader != null) {
                    proBufferReader.close();
                }
            }
            catch (Exception e) {
                throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u901a\u8fc7\u8def\u5f84-\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u6d41\u5173\u95ed\u5931\u8d25", e);
            }
        }
    }

    public static OnethingConfig loadOnethingConfigFromJson() {
        String jsonPath = AppConfig.getProperty((String)"onething.config.json.path");
        OnethingConfig onethingConfig = null;
        if (StringUtils.isBlank((CharSequence)jsonPath)) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u8bfb\u53d6\u914d\u7f6ejson\u6587\u4ef6\u5931\u8d25-\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6ejson\u8def\u5f84");
        }
        Boolean existFile = new File(jsonPath).exists();
        if (!existFile.booleanValue()) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u8bfb\u53d6\u914d\u7f6ejson\u6587\u4ef6\u5931\u8d25-\u914d\u7f6ejson\u8def\u5f84\u6ca1\u6709\u5bf9\u5e94\u6587\u4ef6");
        }
        String jsonStr = null;
        try {
            Path path = Paths.get(jsonPath, new String[0]);
            jsonStr = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u8bfb\u53d6\u914d\u7f6ejson\u6587\u4ef6\u5931\u8d25-\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            throw new OnethingException(9999, "\u4e00\u4ef6\u4e8b-\u8bfb\u53d6\u914d\u7f6ejson\u6587\u4ef6\u5931\u8d25-\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        onethingConfig = (OnethingConfig)JSON.parseObject((String)jsonStr, OnethingConfig.class);
        return onethingConfig;
    }

    public static void setOnethingJsonPath(String path) {
        System.getProperties().put("onething.config.json.path", path);
    }
}

