package cn.gtmap.onething.util;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.dto.lsh.LshDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月11日
 * @description
 */
public class LshUtil {
    public static final Logger log = Logger.getLogger(LshUtil.class);

    public static String getLsh(String lshlx, String lshws) {
        String lsh = null;
        OnethingConfig config = PropertiesLoadUtil.loadOnethingConfigFromJson();
        String lshUrl = config.getServiceAddress() + "/api/v1/getLsh";
        LshDTO lshDTO = new LshDTO(config.getTokenXzqdm(), lshlx, lshws);
        String result = HttpUtil.sendPost(lshUrl, null, "一件事-获取流水号", JSON.toJSONString(lshDTO), null, null);
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(onethingResultDTO.getData()));
        lsh = MapUtils.getString(jsonObject, "lsh");
        return lsh;
    }

    public static String getOnetingInternalNo(String orgId, String onethingCode, OnethingConfig config) {
        String internalNo = null;
        String idNumber = config.getIdNumber(orgId);
        String xscjdm = config.getXscjdm();
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = idNumber + xscjdm + onethingCode + "TC";
        String lsh = getLsh(lshlx, String.valueOf(4));
        internalNo = idNumber + xscjdm + onethingCode + formattedDate + lsh + "TC";
        String loginfo = "获取一件事全省唯一办件编号:" + internalNo + ",统一信用代码:" + idNumber + ",层级代码:" + xscjdm + ",当前日期:" + formattedDate + ",一件事主题编码:" + onethingCode + ",流水号类型:" + lshlx + ",流水号位数:" + 4;
        log.info(loginfo);
        return internalNo;
    }

    public static String getOneMatterInternalNo(String orgId, String onethingCode, OnethingConfig config) {
        String internalNo = null;
        String idNumber = config.getIdNumber(orgId);
        String xscjdm = config.getXscjdm();
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = idNumber + xscjdm + onethingCode;
        String lsh = getLsh(lshlx, String.valueOf(4));
        internalNo = idNumber + xscjdm + onethingCode + formattedDate + lsh;
        String loginfo = "获取一件事全省唯一办件编号:" + internalNo + ",统一信用代码:" + idNumber + ",层级代码:" + xscjdm + ",当前日期:" + formattedDate + ",一件事主题编码:" + onethingCode + ",流水号类型:" + lshlx + ",流水号位数:" + 4;
        log.info(loginfo);
        return internalNo;
    }

    public static String getOneMatterBjNo() {
        String no = null;
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = "DSXBJ";
        String lsh = getLsh(lshlx, String.valueOf(7));
        no = lshlx + formattedDate + lsh;
        log.info("获取单事项办结NO:" + no);
        return no;
    }

    public static String getOneMatterSpNo() {
        String no = null;
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = "DSXSP";
        String lsh = getLsh(lshlx, String.valueOf(7));
        no = lshlx + formattedDate + lsh;
        log.info("获取单事项办结NO:" + no);
        return no;
    }
}
