package cn.gtmap.onething.util;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.dto.jointcode.JointCodeGetDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月14日
 * @description
 */
public class JointCodeUtil {

    public static String getJointCode(String xzqdm, String yjsztfwbm) {
        String jointCode = null;
        OnethingConfig config = PropertiesLoadUtil.loadOnethingConfigFromJson();
        String jointCodeUrl = config.getServiceAddress() + "/api/v1/generateJointCode";
        JointCodeGetDTO jointCodeGetDTO = new JointCodeGetDTO(xzqdm,yjsztfwbm);
        String result = HttpUtil.sendPost(jointCodeUrl, null, "一件事-获取jointCode", JSON.toJSONString(jointCodeGetDTO), null, null);
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(onethingResultDTO.getData()));
        jointCode = MapUtils.getString(jsonObject, "jointCode");
        return jointCode;
    }
}
