package cn.gtmap.onething.entity.dto.onething.bj;

import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.oneting.bj.YjsBj;
import cn.gtmap.onething.util.StringUtil;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class BjFinishInfo {
    private String no;
    private String areaNo;
    private String areaName;
    private String yearFlag;
    private String jointCode;
    private String onethingCode;
    private String finishDate;
    private String finishDeptName;
    private String finishUserName;
    private OnethingExtinfo extInfo;

    public BjFinishInfo(YjsBj yjsBj) {
        this.areaNo = StringUtil.padZero(yjsBj.getXzqdm(), 12);
        LocalDate currentDate = LocalDate.now();
        int currentYear = currentDate.getYear();
        this.yearFlag = String.valueOf(currentYear);
        this.finishDate = yjsBj.getFinishInfo().getFinishDate();
        this.finishDeptName = yjsBj.getFinishInfo().getFinishDeptName();
        this.finishUserName = yjsBj.getFinishInfo().getFinishUserName();
        this.extInfo = yjsBj.getExtInfo();
    }
}
