package cn.gtmap.onething.entity.dto.onematter.sj;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlApplicant;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlProject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class OmSjBasicinfo {
    private String org_id;
    private String org_name;
    private String dept_ql_reg_no;
    private String dept_ql_name;
    private String dept_yw_reg_no;
    private String dept_yw_name;
    private String department;
    private String transact_affair_name;
    private String content;
    private String if_urgent;
    private String sq_way;
    private String applicant_type;
    private String applicant_name;
    private String applicant_paper_type;
    private String applicant_paper_code;
    private String applicant_mobile;
    private String applicant_phone;
    private String applicant_address;
    private String applicant_zipcode;
    private String applicant_emall;
    private String applicant_code;
    private String oper_man_name;
    private String linkman_name;
    private String linkman_paper_type;
    private String linkman_paper_code;
    private String linkman_mobile;
    private String linkman_phone;
    private String linkman_address;
    private String linkman_zipcode;
    private String linkman_email;
    private List<OmSjApplicant> applicantlist;
    private String ye_ms;
    private String sj_file_remark;
    private String anticipate;
    private String anticipate_day_type;
    private String promise;
    private String promise_type;
    private String wapply_date;
    private String apply_date;
    private String bj_statu;
    private String apply_type;
    private String data_sources;
    private String formUrl;
    private OmSjForms forms;
    private OmSjFormsBrief formsBrief;
    private String acceptdate;
    private String acceptusername;
    private String itemno;
    private String ql_kind;
    private String state;
    private String wwsq_way;
    private String catalog_code;
    private String task_version;
    private String apply_docno;
    private OnethingExtinfo extinfo;

    public OmSjBasicinfo(DsxSjSl dsxSjSl, DsxSjSlProject dsxSjSlProject) {
        OnethingConfig config = dsxSjSl.getOnethingConfig();
        String org_id = dsxSjSlProject.getBasicinfo().getOrg_id();
        this.org_id = config.getRealOrgId(org_id);
        this.org_name = config.getOrgName(org_id);
        this.dept_ql_reg_no = config.getDeptQlRegNo(org_id);
        this.dept_ql_name = config.getDeptQlName(org_id);
        this.dept_yw_reg_no = config.getDeptYwRegNo(org_id);
        this.dept_yw_name = config.getDeptYwName(org_id);
        this.transact_affair_name = config.getTransactAffairName(org_id);
        this.sq_way = dsxSjSlProject.getBasicinfo().getSq_way();
        DsxSjSlApplicant dsxSjSlApplicant = dsxSjSlProject.getBasicinfo().getApplicantlist().get(0);
        this.applicant_type = dsxSjSlApplicant.getApplicant_type();
        this.applicant_name = dsxSjSlApplicant.getApplicant_name();
        this.applicant_paper_type = dsxSjSlApplicant.getApplicant_paper_type();
        this.applicant_paper_code = dsxSjSlApplicant.getApplicant_paper_code();
        this.linkman_name = dsxSjSlApplicant.getLinkman_name();
        this.linkman_paper_type = dsxSjSlApplicant.getLinkman_paper_type();
        this.linkman_paper_code = dsxSjSlApplicant.getLinkman_paper_code();
        String onethingCode = dsxSjSlProject.getOnethingCode();
        this.anticipate = config.getAnticipate(org_id, onethingCode);
        this.anticipate_day_type = config.getAnticipateDayType(org_id,onethingCode);
        this.promise = config.getPromise(org_id,onethingCode);
        this.promise_type = config.getPromiseType(org_id,onethingCode);
        this.wapply_date = dsxSjSlProject.getBasicinfo().getWapply_date();
        this.bj_statu = dsxSjSlProject.getBasicinfo().getBj_statu();
        this.apply_type = dsxSjSlProject.getBasicinfo().getApply_type();
        this.data_sources = dsxSjSlProject.getBasicinfo().getData_sources();
        this.ql_kind = dsxSjSlProject.getBasicinfo().getQl_kind();
        this.state = "A";
        this.catalog_code = config.getCatalogCode(org_id);
        this.task_version = config.getTaskVersion(org_id);
        this.extinfo = dsxSjSlProject.getBasicinfo().getExtInfo();
        this.forms = new OmSjForms();
        this.formsBrief = new OmSjFormsBrief();

        List<DsxSjSlApplicant> applicantlist = dsxSjSlProject.getBasicinfo().getApplicantlist();
        List<OmSjApplicant> omSjApplicantList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(applicantlist)) {
            for (DsxSjSlApplicant sjSlApplicant : applicantlist) {
                OmSjApplicant omSjApplicant = new OmSjApplicant(sjSlApplicant);
                omSjApplicantList.add(omSjApplicant);
            }
        }
        this.applicantlist = omSjApplicantList;
    }
}
