package cn.gtmap.onething.entity.bo.onematter.bj;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onematter.bj.OmBjResultInfo;
import cn.gtmap.onething.entity.dto.onematter.bj.OneMatterBjDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 单事项办件办结接口
 */
@Data
public class DsxBj extends OnethingRequest<DsxBjResult> {
    public static final Logger log = Logger.getLogger(DsxBj.class);
    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区划编码")
    private String xzqdm;

    @Valid
    @NoEmpty(fieldExplain = "projectList")
    private List<DsxBjProject> projectList;

    @Override
    public DsxBjResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        this.setJkms("单事项办件办结接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushFinishProjectInfo";
        //初始化DTO 作为入参
        OneMatterBjDTO oneMatterBjDTO = new OneMatterBjDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(oneMatterBjDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        DsxBjResult dsxBjResult = new DsxBjResult();
        //入参中获取
        List<DsxBjResultInfoResult> resultinfoReturn = new ArrayList<>();
        List<OmBjResultInfo> resultinfo = oneMatterBjDTO.getData().getParams().getProjectlist().get(0).getProjectinfo().getResultinfo();
        if (CollectionUtils.isNotEmpty(resultinfo)) {
            for (OmBjResultInfo omBjResultInfo : resultinfo) {
                DsxBjResultInfoResult dsxBjResultInfoResult = new DsxBjResultInfoResult(omBjResultInfo);
                resultinfoReturn.add(dsxBjResultInfoResult);
            }
        }
        dsxBjResult.setResultinfo(resultinfoReturn);
        dsxBjResult.setCode(onethingResultDTO.getHead().getCode());
        dsxBjResult.setMsg(onethingResultDTO.getHead().getMsg());
        dsxBjResult.setOnethingRequestParam(oneMatterBjDTO);
        dsxBjResult.setOnethingResultDTO(onethingResultDTO);
        log.info("单事项办件办结接口-最终结果:" + JSON.toJSONString(dsxBjResult));
        return dsxBjResult;
    }
}
