/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ServletOutputStream out = new WapperedOutputStream(this.buffer);
    private PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8));
    private String customContentType = "application/json;charset=UTF-8";

    public ResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public String getContentType() {
        return this.customContentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void reset() {
        this.buffer.reset();
    }

    public String getResponseData(String charset) throws IOException {
        this.flushBuffer();
        byte[] bytes = this.buffer.toByteArray();
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static class WapperedOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos = null;

        public WapperedOutputStream(ByteArrayOutputStream stream) throws IOException {
            this.bos = stream;
        }

        public void write(int b) throws IOException {
            this.bos.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener listener) {
        }
    }
}

