package cn.gtmap.hlw.core.dto.forward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 转发响应结果DTO
 *
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a
 * @version 1.0
 * @description 封装转发请求的响应结果
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("转发响应结果")
public class ForwardResponseDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "目标URL地址", example = "https://api.example.com/data")
    private String targetUrl;

    @ApiModelProperty(value = "HTTP状态码", example = "200")
    private Integer statusCode;

    @ApiModelProperty(value = "响应头信息")
    private Map<String, String> headers;

    @ApiModelProperty(value = "响应体内容")
    private String body;

    @ApiModelProperty(value = "响应时间(毫秒)", example = "1500")
    private Long responseTime;

    @ApiModelProperty(value = "是否成功", example = "true")
    private Boolean success;

    @ApiModelProperty(value = "错误信息")
    private String errorMessage;
}

