package cn.gtmap.hlw.core.dto.cxtj;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a
 * @version 1.0, 2025/9/23
 * @description 统计图对象
 */
@Data
@NoArgsConstructor
public class DashboardDTO {
    private String id;       // 图表ID
    private String type;     // pie, line, bar
    private String title;    // 图表标题
    private List<String> labels; // 横坐标 (饼图可为空)
    private List<SeriesDTO> series;



    public DashboardDTO(String id, String type, String title) {
        this.id = id;
        this.type = type;
        this.title = title;
    }

    public void init(DashboardDTO dashboardPz) {
        if (CollectionUtils.isNotEmpty(dashboardPz.getLabels())) {
            this.labels = dashboardPz.getLabels();
        }
        if (CollectionUtils.isNotEmpty(dashboardPz.getSeries())) {
            this.series = dashboardPz.getSeries();
            this.series.forEach(s -> s.setType(this.type));
        }
    }
}
