package cn.gtmap.hlw.core.dao.menu;


import cn.gtmap.hlw.core.model.GxYyFunctionMenu;

import java.util.List;

/**
 * (GxYyFunctionMenu)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyFunctionMenuDao {

    /**
     * 根据RoleId查询实体对象
     *
     * @param roleId 角色id
     * @return 影响行数
     */
     List<GxYyFunctionMenu> getFunctionMenu(String roleId);
    /**
     * 新增数据
     *
     * @param menuList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<GxYyFunctionMenu> menuList);
    /**
     * 新增数据
     *
     * @param menuList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyFunctionMenu> menuList);
    /**
     * 通过菜单id和角色id查询数据
     *
     * @param functionId 菜单id
     * @param roleId 角色id
     * @return 影响行数
     */
    GxYyFunctionMenu getByFunctionIdAndRole(String functionId, String roleId);
    /**
     * 删除数据
     *
     * @param roleId 角色
     * @return 影响行数
     */
    void deleteByRoleId(String roleId);
    /**
     * 根据FunctionMenuId查询实体对象
     * @param functionMenuIds
     * @param roleId
     * @return
     */
    List<GxYyFunctionMenu> getyFunctionMenuIdsAndRoleId(List<String> functionMenuIds,String roleId);
    /**
     * 根据FunctionMenuId和角色id集合删除
     * @param functionMenuId
     * @param roleIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteByFunctionMenuIdAndRole(String functionMenuId, List<String> roleIdList);
    /**
     * 根据菜单id查询
     * @param functionMenuId
     * @return:List<GxYyFunctionMenuPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyFunctionMenu> getByFunctionMenuId(String functionMenuId);
    /**
     * 根据FunctionMenuId删除
     * @param functionMenuId
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteByFunctionMenuId(String functionMenuId);
}

