package cn.gtmap.hlw.core.model.query.sqxx;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/3
 * @description 申请信息查询条件
 */
@Data
@NoArgsConstructor
public class GxYySqxxQuery extends BasePage {

    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 创建人名称
     */
    private String userName;

    private String userZjId;
    /**
     * 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id
     */
    private List<String> orgIdList;
    /**
     * 需要查询的SLZT gx_yy_sqxx.slzt
     */
    private List<String> slztList;
    /**
     * 不需要查询的SLZT gx_yy_sqxx.slzt
     */
    private List<String> noQuerySlztList;
    /**
     * 需要查询的SLZT gx_yy_sqxx.slzt
     */
    private String slzt;
    /**
     * 受理编号 gx_yy_sqxx.slbh
     */
    private String slbh;
    /**
     * 受理编号反序
     */
    private String slbhReverse;
    /**
     * 业务系统受理编号 gx_yy_sqxx.ywxtslbh
     */
    private String ywxtslbh;
    /**
     * 权利人名称 gx_yy_sqxx.qlrmc ；不区分是否组合登记，都查
     */
    private String qlrmc;
    /**
     * 义务人名称
     */
    private String ywrmc;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlx;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlxmh;
    /**
     * 坐落 gx_yy_sqxx.zl 支持模糊查询
     */
    private String zl;
    /**
     * 税务状态 gx_yy_sqxx.swzt
     */
    private List<String> swztList;
    /**
     * 缴费状态 gx_yy_sqxx.jfzt
     */
    private List<String> jfztList;
    /**
     * 开始时间：yyyy-mm-dd   gx_yy_sqxx.create_date
     */
    private String kssj;
    /**
     * 开始时间：yyyy-mm-dd   gx_yy_sqxx.create_date
     */
    private String jssj;

    /**
     * gx_yy_sqxx_htxx.BAZTDM 备案状态代码
     */
    private String bazt;

    /**
     * 是否已退回（区别已退回台账）
     */
    private String sfyth;
    /**
     * 是否认证 gx_yy_sqxx_hq
     */
    private String sfrz;
    /**
     * 导出状态
     */
    private String dczt;
    /**
     * 受理编号集合
     */
    private List<String> slbhList;
    /**
     * 申请类型集合
     */
    private List<String> sqlxList;

    /**
     * 审核人
     */
    private String editUser;

    /**
     * 审核人
     */
    private List<String> editUserList;
    /**
     * 审核部门
     */
    private String shOrgId;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 区域代码集合
     */
    private List<String> qydmList;
    /**
     * 角色id
     */
    private String roleId;
    /**
     * 权利人名称
     */
    private List<String> qlrmcList;

    /**
     * 是否收税收费（0：否，1：是）
     */
    private String sfsssf;
    private String isBank;

    /**
     * 预审通过时间不为空
     */
    private String yytgsjNotNull;

    /**
     * 是否需要云签 0：否 1：是，（整个流程是否需要发起云签）
     */
    private String sfyq;
    /**
     * 数据源
     */
    private String sjy;
    /**
     * 税务状态
     */
    private String swzt;
    /**
     * 是否只查询一窗数据
     */
    private String sfzcxycsj;

    /**
     * 是否查询登录用户角色办件(false:否，true:是)
     */
    private String sfcxdlyhjsbj;

    /**
     * 岗位
     */
    private String gw;
    /**
     * 用章操作人id
     */
    private String yzczrid;
    /**
     * 云签创建状态
     */
    private String cjzt;
    /**
     * 需要查询的SLZT gx_yy_sqxx.sqlx
     */
    private List<String> noYqList;
    /**
     * 土地证号
     */
    private String tdzh;
    /**
     * 抵押人
     */
    private String dyr;
    /**
     * 抵押权人
     */
    private String dyqr;
    /**
     * 缴费状态
     */
    private String jfzt;
    /**
     * 匹配状态
     */
    private String ppzt;
    /**
     * 移交状态
     */
    private String yjzt;
    /**
     * 缴费人姓名
     */
    private String jfrxm;
    /**
     * 缴款开始时间：yyyy-mm-dd   wct_jy_ddxx.ddsj
     */
    private String jkkssj;
    /**
     * 缴款结束时间：yyyy-mm-dd   wct_jy_ddxx.ddsj
     */
    private String jkjssj;
    /**
     * 认领状态
     */
    private List<String> rlztList;
    /**
     * 缴费方式
     */
    private String jffs;
    /**
     * 申请信息来源
     */
    private String sqxxly;
    /**
     * 查询申请
     */
    private String cxsq;
    /**
     * 认领人id
     */
    private String rlrid;
    /**
     * 受理编号左模糊
     */
    private String slbhzmh;
    /**
     * 缴费人姓名模糊
     */
    private String jfrxmmh;
    /**
     * 优先展示受理状态，查询结果排在前面的受理状态
     */
    private List<String> yxzsSlztList;
    /**
     * 组合流程展示抵押信息(0：否；1：是)
     */
    private String zhlcZsDyxx;
    /**
     * 买卖合同号
     */
    private String mmhth;
    /**
     * 规划用途
     */
    private String ghyt;
    /**
     * 查询本人审核、未审核的
     */
    private String shr;

    public GxYySqxxQuery(String kssj, String jssj) {
        this.kssj = kssj;
        this.jssj = jssj;
    }
}
