package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.node.INode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


/**
 * (GxYyMenu)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyMenu implements INode<GxYyMenu> {
    private static final long serialVersionUID = -5528796935565029343L;
    /**
     * 主键
     */
    private String id;

    /**
     * 功能菜单ID
     */
    private String functionMenuId;

    /**
     * 客户端类型(1为微信，2为web,3为APP，4为其他)
     */
    private String clientType;

    /**
     * 是否常用（0：是，1：否）
     */
    private String isCommon;

    /**
     * 区域类型（0:顶部头，1：上边栏，2：左侧边栏，3：更多）
     */
    private String areaType;

    /**
     * 描述
     */
    private String describe;

    /**
     * 链接地址
     */
    private String href;

    /**
     * 图标地址
     */
    private String icon;

    /**
     * 功能名称
     */
    private String name;

    private String icon1;

    private String icon2;

    /**
     * 父应用名称
     */
    private String parentName;

    /**
     * 父应用ID
     */
    private String parentId;

    /**
     * 排序
     */
    private Integer orderNumber;

    /**
     * 是否需求授权资源范围（0：是，1：否）
     */
    private String isAuthorize;

    private String sqlxId;

    /**
     * 预约类型（0：直接预约，1：预审预约；）
     */
    private Integer yylx;

    /**
     * 菜单类型分类(0:目录按钮；1:手机按钮；2、神行类型)
     */
    private Integer cdlx;

    /**
     * 备注
     */
    private String bz;

    /**是否新一窗**/
    private String sfxyc;

    /**
     * 申请类型的外键 关联gx_yy_zd_yypz的id
     */
    private String yypzId;

    /**
     * 菜单所属角色
     */
    private String roleId;
    /**
     * 是否默认授权（0：否，1：是）
     */
    private String sfmrsq;

    /**
     * 子孙节点
     */
    private List<GxYyMenu> children;

    @Override
    public List<GxYyMenu> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        return this.children;
    }
}

