package cn.gtmap.hlw.core.dao.menu;

import cn.gtmap.hlw.core.dto.menu.index.IndexConfigQueryDTO;
import cn.gtmap.hlw.core.dto.menu.menu.MenuQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyFunctionMenu;
import cn.gtmap.hlw.core.model.GxYyMenu;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * (GxYyProcess)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 15:06:30
 */
public interface GxYyMenuDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyMenu get(String id);


    /**
     * 修改数据
     *
     * @param queryDTO          查询条件对象
     * @param gxYyFunctionMenus 功能菜单对象集合
     * @return 影响行数
     */

    List<GxYyMenu> getMenuByQueryParams(IndexConfigQueryDTO queryDTO, List<GxYyFunctionMenu> gxYyFunctionMenus);

    /**
     * 根据菜单ID查询GxYyMenu
     *
     * @param functionMenuId 菜单ID
     * @return GxYyMenu
     */
    GxYyMenu getMenuByFunctionMenuId(String functionMenuId);

    /**
     * 获取数据
     *
     * @param functionMenuList 功能菜单集合
     * @param clientype        客户端类型
     * @param areaType         区域类型
     * @return 影响行数
     */
    List<GxYyMenu> getMenuListByFunctionMenu(List<String> functionMenuList, String clientype, String areaType);

    /**
     * 获取数据
     *
     * @param functionMenuIds 功能菜单id集合
     * @param clientype       客户端类型
     * @param areaType        区域类型
     * @param roleId          角色id
     * @return 影响行数
     */
    List<GxYyMenu> getMenuListByFunctionMenuIds(List<String> functionMenuIds, String clientype, String areaType, String roleId);

    /**
     * 根据 sqlx+CLIENT_TYPE去查询
     *
     * @param sqlxdm
     * @param clientType
     * @return
     */
    GxYyMenu getMenuBySqlxAndClientType(String sqlxdm, String clientType);

    /**
     * 根据角色查询菜单
     *
     * @param roleId
     * @return
     */
    List<GxYyMenu> getMenuByRoleId(String roleId);

    /**
     * 根据MenuQueryParamsDTO查询菜单
     *
     * @param queryDTO
     * @return
     */
    List<GxYyMenu> getMenuByMenuQueryParams(MenuQueryParamsDTO queryDTO);

    /**
     * 菜单--分页查询
     *
     * @param paramsDTO
     * @return GxYyMenuPO集合
     */
    IPage<GxYyMenu> queryPage(MenuQueryParamsDTO paramsDTO);

    /**
     * 根据id删除
     *
     * @param paramsDTO
     */
    void deleteById(MenuQueryParamsDTO paramsDTO);

    /**
     * 删除
     *
     * @param functionMenuId
     * @param roleIdList
     */
    void deleteByFunctionMenuIdAndRole(String functionMenuId, List<String> roleIdList);

    /**
     * 保存更新
     *
     * @param gxYyMenu
     */
    void saveOrUpdateMenu(GxYyMenu gxYyMenu);

    /**
     * 菜单查询
     *
     * @param areaType
     * @param clientType
     * @param roleId
     * @return GxYyMenuPO集合
     */
    List<GxYyMenu> getMenuListByAreaTypeAndClientType(String areaType, String clientType, String roleId);

    /**
     * 批量保存
     *
     * @param menuList 实例对象集合
     * @return 影响行数
     */
    void saveBatch(List<GxYyMenu> menuList);

    /**
     * 菜单查询
     *
     * @param functionMenuIdList
     * @return:List<GxYyMenuPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> listByFunctionMenuIdList(List<String> functionMenuIdList);

    /**
     * 批量插入
     *
     * @param menuList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyMenu> menuList);

    /**
     * 根据菜单id集合删除
     *
     * @param functionMenuIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFunctionMenuIdList(List<String> functionMenuIdList);

    /**
     * 根据sqlx查询
     *
     * @param sqlx
     * @return:List<GxYyMenuPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> listBySqlx(String sqlx);
    /**
     * 批量保存或更新
     *
     * @param menuPoList 实例对象集合
     * @return
     */
    void saveOrUpdateBatch(List<GxYyMenu> menuPoList);
    /**
     * 根据sqlx、clientType查询
     * @param sqlx
     * @param clientType
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyMenu>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> listBySqlxAndClientType(String sqlx, String clientType);
}

