package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxWlxx;

import java.util.List;

/**
 * 申请信息_物流信息(GxYySqxxWlxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxWlxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param wlid 主键
     * @return 实例对象
     */
    GxYySqxxWlxx get(String wlid);
    /**
     * 获取数据
     *
     * @param slbh
     * @param sqid
     * @return 实例对象
     */
    List<GxYySqxxWlxx> getBySlbhAndSqid(String slbh,String sqid);

    /**
     * 通过ID查询数据集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYySqxxWlxx> list(String sqid);

    /**
     * 通过sqidList查询数据集合
     *
     * @param sqidList 申请ID
     * @return 实例对象
     */
    List<GxYySqxxWlxx> list(List<String> sqidList);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh 主键
     * @return 实例对象
     */
    List<GxYySqxxWlxx> getBySlbh(String slbh);

    /**
     * 新增数据
     *
     * @param gxYySqxxWlxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxWlxx gxYySqxxWlxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxWlxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxWlxx gxYySqxxWlxx);

    /**
     * 批量新增或修改数据
     *
     * @param gxYySqxxWlxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxWlxx> gxYySqxxWlxxList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 实例对象
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);
    /**
     * 根据slbh删除
     * @param slbh
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySlbh(String slbh);
    /**
     * 批量保存
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYySqxxWlxx> gxYySqxxWlxxList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 获取当天最大物流订单号
     */
    String getDtMaxDdh();

    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    ///void delete(String slbh);
}

