package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 预审台账状态表(GxYyYstzzt)实体类
 *
 * @author fenghaorui
 * @since 2024-03-14 14:04:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyYstzzt implements Serializable {
    private static final long serialVersionUID = -22898562906526379L;
    /**
     * 主键
     */
    private String id;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 申请ID
     */
    private String sqid;
    /**
     * 状态（1：保存完成2：推送信息完成3：完税信息获取完成4：获取三要素完成）
     */
    private Integer zt;
    /**
     * 是否启用一卡清(1:是 0：否)
     */
    private String sfqyykq;
    /**
     * 是否启用一窗受理(1:是 0：否)
     */
    private String sfqyycsl;

}

