package cn.gtmap.hlw.core.enums.status;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/11/24
 * @description 物流状态
 */
@Getter
@AllArgsConstructor
public enum WlztEnum {
    /**
     * 收寄
     */
    SJ("00", "收寄"),
    /**
     * 妥投
     */
    TT("10", "妥投"),
    /**
     * 未妥投
     */
    WTT("20", "未妥投"),
    /**
     * 经转过程中
     */
    JZGCZ("30", "经转过程中"),
    /**
     * 离开处理中心
     */
    LKCLZX("40", "离开处理中心"),
    /**
     * 到达处理中心
     */
    DDCLZX("41", "到达处理中心"),
    /**
     * 安排投递
     */
    APTD("50", "安排投递");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (WlztEnum xq : WlztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
