/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.config;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.ApiSecurityUtils;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.ContentType;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.util.WebUtils;

public class EncryptRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(EncryptRequestWrapper.class);
    protected FastByteArrayOutputStream cachedContent;
    protected String jsPublicKey;

    public EncryptRequestWrapper(HttpServletRequest request) {
        super(request);
        this.copyBody();
    }

    public static EncryptRequestWrapper newOrGetMultiReadHttpServletRequest(HttpServletRequest request) {
        EncryptRequestWrapper multiReadHttpServletRequest = EncryptRequestWrapper.getMultiReadHttpServletRequest(request);
        if (null != multiReadHttpServletRequest) {
            return multiReadHttpServletRequest;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains(ContentType.MULTIPART.getValue())) {
            request = new StandardServletMultipartResolver().resolveMultipart(request);
        }
        return new EncryptRequestWrapper(request);
    }

    public static EncryptRequestWrapper getMultiReadHttpServletRequest(HttpServletRequest request) {
        EncryptRequestWrapper nativeRequest = (EncryptRequestWrapper)((Object)WebUtils.getNativeRequest((ServletRequest)request, EncryptRequestWrapper.class));
        if (null != nativeRequest) {
            return nativeRequest;
        }
        if (request instanceof EncryptRequestWrapper) {
            return (EncryptRequestWrapper)request;
        }
        return null;
    }

    protected void copyBody() {
        int length = this.getContentLength();
        if (length > 0) {
            this.cachedContent = IoUtil.read((InputStream)this.getRequest().getInputStream());
            String body = new String(this.cachedContent.toByteArray());
            if (StringUtils.isNotBlank((CharSequence)body)) {
                ApiEncryptBody jsonBody = (ApiEncryptBody)JSONObject.parseObject((String)body, ApiEncryptBody.class);
                if (null != jsonBody) {
                    String dataEncrypt = jsonBody.getData();
                    String sm4key = jsonBody.getParamid();
                    this.jsPublicKey = jsonBody.getFrontKey();
                    String data = ApiSecurityUtils.decrypt(sm4key, dataEncrypt);
                    if (StringUtils.isNotBlank((CharSequence)data)) {
                        body = "undefined".equalsIgnoreCase(data) || StringUtils.isBlank((CharSequence)data) ? "{}" : data;
                    }
                }
                this.cachedContent.reset();
                this.cachedContent.write(body.getBytes(), 0, body.getBytes().length);
            }
        } else {
            this.cachedContent = new FastByteArrayOutputStream();
        }
    }

    public int getContentLength() {
        if (null != this.cachedContent) {
            return this.cachedContent.size();
        }
        return super.getContentLength();
    }

    public String getBody() {
        String body = null;
        if (this.cachedContent != null && this.cachedContent.size() > 0) {
            body = new String(this.cachedContent.toByteArray());
        }
        return body;
    }

    public String getSortBody() {
        return JSONObject.toJSONString((Object)this.getBody(TreeMap.class));
    }

    public <T> T getBody(Class<T> type) {
        return (T)JSONUtil.toBean((String)this.getBody(), type);
    }

    public String getJSPublicKey() {
        return this.jsPublicKey;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.getContentLength() < 1) {
            return super.getInputStream();
        }
        return new ResettableServletInputStream(new ByteArrayInputStream(this.cachedContent.toByteArray()));
    }

    private class ResettableServletInputStream
    extends ServletInputStream {
        private final InputStream sourceStream;
        private boolean finished = false;

        public ResettableServletInputStream(InputStream sourceStream) {
            Assert.notNull((Object)sourceStream, (String)"Source InputStream must not be null", (Object[])new Object[0]);
            this.sourceStream = sourceStream;
        }

        public final InputStream getSourceStream() {
            return this.sourceStream;
        }

        public int read() throws IOException {
            int data = this.sourceStream.read();
            if (data == -1) {
                this.finished = true;
            }
            return data;
        }

        public int available() throws IOException {
            return this.sourceStream.available();
        }

        public void close() throws IOException {
            super.close();
            this.sourceStream.close();
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

