package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyZdXzqy;

import java.util.List;

/**
 * 行政区域划分等级表(GxYyZdXzqy)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdXzqyRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dm 主键
     * @return 实例对象
     */
    GxYyZdXzqy get(String dm);

    /**
     * 新增数据
     *
     * @param gxYyZdXzqy 实例对象
     * @return 影响行数
     */
    void save(GxYyZdXzqy gxYyZdXzqy);

    /**
     * 修改数据
     *
     * @param gxYyZdXzqy 实例对象
     * @return 影响行数
     */
    void update(GxYyZdXzqy gxYyZdXzqy);
    /**
     * 查询列表
     *
     * @param dm 代码
     * @param dj 行政区域划分等级（1：省，2：市：3：县）
     * @return 影响行数
     */
    List<GxYyZdXzqy> list(String dm,String dj);

    /**
     * 根据代码查询名称
     * @param sjrszsheng
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    String getRedisUtilsDictMcByDm(String sjrszsheng);

    /**
     * 获取所有行政区域
     *
     * @return 行政区域列表
     */
    List<GxYyZdXzqy> getAll();
}

