package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.zddz.ZdDzPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdDz;

import java.util.List;

/**
 * (GxYyZdDz)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-03 17:36:10
 */
public interface GxYyZdDzRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZdDz get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZdDz 实例对象
     * @return 影响行数
     */
    void save(GxYyZdDz gxYyZdDz);

    /**
     * 修改数据
     *
     * @param gxYyZdDz 实例对象
     * @return 影响行数
     */
    void update(GxYyZdDz gxYyZdDz);

    /**
     * 将第三方字段名称对照成我方字典
     *
     * @param sjly
     * @param zdbm
     * @param sjmc
     * @return
     */
    GxYyZdDz getRedisGxYyZdDzByZdbmAndSjmc(String sjly, String zdbm, String sjmc);

    /**
     * 将第三方字段代码对照成我方字典
     *
     * @param sjly
     * @param zdbm
     * @param sjdm
     * @return
     */
    GxYyZdDz getRedisGxYyZdDzByZdbmAndSjdm(String sjly, String zdbm, String sjdm);

    /**
     * 将我方字典名称对照成第三方方字典
     *
     * @param sjly
     * @param zdbm
     * @param mc
     * @return
     */
    GxYyZdDz getRedisGxYyZdDzByZdbmAndMc(String sjly, String zdbm, String mc);

    /**
     * 将我方字典代码对照成第三方方字典
     *
     * @param sjly
     * @param zdbm
     * @param dm
     * @return
     */
    GxYyZdDz getRedisGxYyZdDzByZdbmAndDm(String sjly, String zdbm, String dm);

    /**
     * 根据系统代码和字典编码获取字典列表
     * @param xtdm
     * @param zdbm
     * @return
     */
    List<GxYyZdDz> getRedisGxYyZdDzByZdbm(String xtdm, String zdbm);

    /**
     *查询所有
     * @return
     */
    List<GxYyZdDz> getAll();

    /**
     * 删除
     * @param id
     * @return 删除的条数
     */
    int delete(String id);

    /**
     *分页查询
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyZdDz> queryPage(ZdDzPageParamsDTO paramsDTO);

    /**
     * 保存更新
     *
     * @param gxYyZdDjz
     */
    void saveOrUpdate(GxYyZdDz gxYyZdDjz);

    /**
     * 批量保存更新
     *
     * @param gxYyZdDzList 字典对照集合
     */
    void saveOrUpdateBatch(List<GxYyZdDz> gxYyZdDzList);

    List<GxYyZdDz> getByZdbmAndSjdm(String zdbm, String sjdm);
}

