package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxBg;

import java.util.List;

/**
 * 申请信息变更（变更前）(GxYySqxxBg)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYySqxxBgRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxxBg get(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxBg 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxBg gxYySqxxBg);

    /**
     * 修改数据
     *
     * @param gxYySqxxBg 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxBg gxYySqxxBg);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxBg 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxBg gxYySqxxBg);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxBg> list(List<String> sqidList);

    /**
     * 通过sqidList集合批量删除数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    int deleteBatchIds(List<String> sqidList);
}

