package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqlxJdxx;

import java.util.List;

/**
 * 节点信息(GxYySqlxJdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:50:54
 */
public interface GxYySqlxJdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYySqlxJdxx get(String id);

    /**
     * 新增数据
     *
     * @param gxYySqlxJdxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqlxJdxx gxYySqlxJdxx);

    /**
     * 修改数据
     *
     * @param gxYySqlxJdxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqlxJdxx gxYySqlxJdxx);

    /**
     * 通过申请类型代码查询集合
     *
     * @param sqlxdm 申请类型代码
     * @return 实例对象
     */
    List<GxYySqlxJdxx> getBySqlxdm(String sqlxdm);

    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYySqlxJdxx>
     */
    List<GxYySqlxJdxx> listBySqlx(String sqlx);

    /**
     * 根据sqlx删除
     * @param sqlxdm
     */
    void deleteBySqlx(String sqlxdm);

    /**
     * 批量保存
     * @param sqlxJdxxList
     */
    void insertBatchSomeColumn(List<GxYySqlxJdxx> sqlxJdxxList);

    /**
     * 批量保存或更新
     * @param gxYySqlxJdxxList
     */
    void saveOrUpdateBatch(List<GxYySqlxJdxx> gxYySqlxJdxxList);

    void removeById(String id);
}

