package cn.gtmap.hlw.core.dto.third.sdq;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2025/15/22
 * @description 水电气过户房屋信息
 */
@Data
public class SdqGhFwxxResultDTO {


    /**
     * 部门名称
     */
    private String bmmc;

    /**
     * 部门类型代码（字典 7.38）
     */
    private String bmlxdm;

    /**
     * 部门类型名称（字典 7.38）
     */
    private String bmlxmc;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 不动产权证号
     */
    private String bdcqzh;

    /**
     * 权利人名称（多个逗号拼接）
     */
    private String qlrmc;

    /**
     * 义务人名称（多个逗号拼接）
     */
    private String ywrmc;

    /**
     * 建筑面积（单位：平方米，数值 15,4）
     */
    private BigDecimal jzmj;

    /**
     * 登记时间（格式：yyyy-MM-dd HH:mm:ss）
     */
    private String djsj;

    /**
     * 内网受理编号
     */
    private String nwslbh;
}
