package cn.gtmap.hlw.core.base;

import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @Description page 返回对象
 * @Author admin
 * @Date  2023/6/17 18:04
 **/
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageInfo<T> {

    /**
     * 页码
     */
    private int pageNum;

    /**
     * 分页大小
     */
    private int pageSize;

    /**
     * 排序字段
     */
    private String sidx;

    /**
     * 排序方式
     */
    private String sord;


    /**
     * 分页结果
     */
    private List<T> list;


    /**
     * 总页数
     */
    private int totalPages;

    /**
     * 总数
     */
    private int totalCount;

    public PageInfo(List<T> list, int pageNum, int pageSize, int totalPages, int totalCount) {
        this.list = list;
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.totalPages = totalPages;
        this.totalCount = totalCount;
    }


    /**
     * 获取统一分页对象
     */
    public static <T> PageInfo<T> of(IPage page, Class<T> entityVoClass) {
        int total = (int) page.getTotal();
        int pageSize = (int) page.getSize();
        int records = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;

        PageInfo<T> pageInfo = new PageInfo<>();
        pageInfo.setPageNum((int) page.getCurrent());
        pageInfo.setPageSize(pageSize);
        pageInfo.setList(BeanConvertUtil.copyList(page.getRecords(), entityVoClass));
        pageInfo.setTotalPages(records);
        pageInfo.setTotalCount(total);
        return pageInfo;
    }
}
