package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.dict.fj.ZdFjQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;
import java.util.Set;

/**
 * 不动产附件字典表(GxYyZdFj)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdFjRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dm 主键
     * @return 实例对象
     */
    GxYyZdFj get(Integer dm);

    /**
     * 新增数据
     *
     * @param gxYyZdFj 实例对象
     * @return 影响行数
     */
    void save(GxYyZdFj gxYyZdFj);

    /**
     * 修改数据
     *
     * @param gxYyZdFj 实例对象
     * @return 影响行数
     */
    void update(GxYyZdFj gxYyZdFj);

    /**
     * 根据申请类型、登记原因查看附件
     * @param sqlxList
     * @param djyy
     * @return
     */
    List<GxYyZdFj> getZdFjListByFjywAndDjyy(List<String> sqlxList, String djyy);

    /**
     * 根据附件类型查询
     * @param fjlx 附件类型
     * @return:GxYyZdFj
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyZdFj getByFjlx(String fjlx, String sqlx);

    /**
     * 根据附件类型查询集合
     * @param sqlxList
     * @return:GxYyZdFj
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyZdFj> getBySqlx(Set<String> sqlxList);

    /**
     * 根据sqlx集合和fjlx查询
     *
     * @param sqlxList
     * @param fjlx
     * @return:GxYyZdFj
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdFj getBySqlxListAndFjlx(List<String> sqlxList, String fjlx);

    /**
     * 根据sqlx获取不推送登记的附件类型集合
     *
     * @param sqlx 申请类型
     * @return:附件类型集合
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<String> getNoPushDjZdFjlxBySqlx(String sqlx, String djyy);

    /**
     * 根据sqlx查询
     *
     * @param sqlx
     * @return:List<GxYyZdFj>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listBySqlx(String sqlx);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return:IPage<GxYyZdFj>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYyZdFj> page(ZdFjQueryParamsDTO queryDTO);

    /**
     * 批量更新保存
     *
     * @param zdFjList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void batchSaveOrUpdate(List<GxYyZdFj> zdFjList);

    /**
     * 更新保存
     *
     * @param zdFj
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdate(GxYyZdFj zdFj);

    /**
     * 根据id查询
     *
     * @param id
     * @return:GxYyZdFj
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdFj get(String id);

    /**
     * 根据id删除
     *
     * @param id
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delete(String id);

    /**
     * 根据fjlx集合和sqlx查询
     *
     * @param list
     * @param sqlx
     * @return:List<GxYyZdFj>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listByFjlxdmListAndSqlx(List<String> list, String sqlx);

    /**
     * 根据sqlx集合查询
     *
     * @param sqlxList
     * @return:List<GxYyZdFj>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listBySqlxList(List<String> sqlxList);

    /**
     * 批量插入
     *
     * @param zdFjList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyZdFj> zdFjList);

    /**
     * 根据附件业务类型删除
     *
     * @param fjYwList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFjYwList(List<String> fjYwList);

    /**
     * 根据sqlx删除
     *
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqlx(String sqlx);
}

