/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.ght;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaUtil {
    private static final Logger logger = LoggerFactory.getLogger(RsaUtil.class);
    private static final String ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";

    public static String encryptByPublicKey(String content, String publicKeyStr) {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)publicKeyStr);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, publicKey);
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            logger.error("RSA\u516c\u94a5\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("RSA\u516c\u94a5\u52a0\u5bc6\u5931\u8d25: " + e.getMessage());
        }
    }

    public static String decryptByPrivateKey(String encryptedContent, String privateKeyStr) {
        PrivateKey privateKey = null;
        try {
            byte[] keyBytes = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            privateKey = keyFactory.generatePrivate(keySpec);
            logger.debug("\u4f7f\u7528PKCS#8\u683c\u5f0f\u89e3\u6790\u79c1\u94a5\u6210\u529f");
        }
        catch (Exception e1) {
            logger.warn("PKCS#8\u683c\u5f0f\u89e3\u6790\u79c1\u94a5\u5931\u8d25\uff0c\u5c1d\u8bd5PKCS#1\u683c\u5f0f: {}", (Object)e1.getMessage());
            try {
                privateKey = RsaUtil.loadPrivateKeyFromPKCS1(privateKeyStr);
                logger.info("\u4f7f\u7528PKCS#1\u683c\u5f0f\u89e3\u6790\u79c1\u94a5\u6210\u529f");
            }
            catch (Exception e2) {
                logger.error("PKCS#1\u683c\u5f0f\u89e3\u6790\u79c1\u94a5\u4e5f\u5931\u8d25", (Throwable)e2);
                throw new RuntimeException("RSA\u79c1\u94a5\u89e3\u6790\u5931\u8d25\uff08\u5df2\u5c1d\u8bd5PKCS#8\u548cPKCS#1\u683c\u5f0f\uff09: " + e2.getMessage());
            }
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, privateKey);
            byte[] decryptedBytes = cipher.doFinal(Base64.decodeBase64((String)encryptedContent));
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("RSA\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("RSA\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25: " + e.getMessage());
        }
    }

    private static PrivateKey loadPrivateKeyFromPKCS1(String privateKeyStr) throws Exception {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)privateKeyStr);
            RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)keyBytes);
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            logger.error("PKCS#1\u683c\u5f0f\u79c1\u94a5\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new Exception("\u65e0\u6cd5\u89e3\u6790PKCS#1\u683c\u5f0f\u79c1\u94a5: " + e.getMessage(), e);
        }
    }

    public static String getAesKey(String encryptedAesKey, String rsaPrivateKey) {
        return RsaUtil.decryptByPrivateKey(encryptedAesKey, rsaPrivateKey);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            logger.info("Bouncy Castle Provider \u5df2\u6ce8\u518c");
        }
    }
}

