/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) {
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String json;
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = json = FileUtils.readFileToString((File)new File("D://json.txt"));
        String paramid = "04a3b073537585a737bbd1cbd4f1dd4e38eef7de5ef7afccc61914f1b8d41a0caca98e4de85ad0a68b445482eed902fd0d420e5eb32743105ffcb2fdb0dbcc5894ed1ed6bca9010b750a74ef6e1ea39eb8a66fb533f866aeba06999f293d9e3570ee16e01b9460e67dd740134560c42ef432597003b987e464bc0539e14cd5f6e17c6d01cf5ba1c2fb58203ca4";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
    }
}

