package cn.gtmap.hlw.core.util.encryption;

import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.util.text.BasicTextEncryptor;

import java.text.ParseException;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/10/23
 * @description
 */
public class JasyptUtil {
    private static PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();

    static {
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        // 配置加密密钥，务必保密
        config.setPassword("onlinerealestate");
        // 设置加密算法
        config.setAlgorithm("PBEWithMD5AndDES");
        // 设置密钥迭代次数，影响破解难度
        config.setKeyObtentionIterations("1000");
        // 设置加密池的大小，1 表示单个实例使用
        config.setPoolSize("1");
        // 盐生成器类，防止彩虹表攻击
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        // 设置输出编码类型为 base64
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
    }

    public static String encode(String plaintext) {
        System.out.println(plaintext);
        String encrypt = encryptor.encrypt(plaintext);
        System.out.println(encrypt);
        return encrypt;
    }

    public static String decode(String ciphertext) {
        System.out.println(ciphertext);
        String decrypt = encryptor.decrypt(ciphertext);
        System.out.println(decrypt);
        return decrypt;
    }


    public static void main(String[] args) throws ParseException {
        encode("gtmap");
        encode("BAZ/RVvMdlLtUtINUY+gTg==");
        encode("81zUrZaWlV0kyLFPTH3wsA==");
        encode("nacos");
        encode("gtmap123!@#");
        encode("guest");
        encode("Gtis@123");

        decode("Gwdwhhm55/reFD/OBLFGAA==");
    }
}
