package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyProcessAnRel;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/1/31
 * @description
 */
public interface GxYyProcessAnRelRepository {
    /**
     * 根据步骤查询
     * @param processId
     * @return:List<GxYyProcessAnRel>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyProcessAnRel> listByProcessId(String processId);

    /**
     * 根据步骤id和按钮id查询
     *
     * @param processId
     * @param anid
     * @return:GxYyProcessAnRelPO
     * @author dingweiwei
     */
    GxYyProcessAnRel getByProcessIdAndAnId(String processId, String anid);

    /**
     * 批量保存
     *
     * @param processAnRelS
     * @return:void
     * @author dingweiwei
     */
    void insertBatchSomeColumn(List<GxYyProcessAnRel> processAnRelS);

    /**
     * 根据步骤id集合删除
     *
     * @param processIdList
     * @return:void
     * @author dingweiwei
     */
    void deleteByProcessIdList(List<String> processIdList);

    /**
     * 根据步骤id集合查询
     *
     * @param processIdList
     * @return:List<GxYyProcessAnRelPO>
     * @author dingweiwei
     */
    List<GxYyProcessAnRel> listByProcessIdList(List<String> processIdList);

    List<GxYyProcessAnRel> getListByIds(List<String> paidList);

    void saveOrUpdateBatch(List<GxYyProcessAnRel> processAnRelPoList);

    void saveOrUpdate(GxYyProcessAnRel processAnRel);

    void deleteById(String paid);

    void updateById(GxYyProcessAnRel processAnRelPo);
}
